/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DDLConstantAction;
import org.apache.derby.shared.common.error.StandardException;

class CreateSchemaConstantAction
extends DDLConstantAction {
    private final String aid;
    private final String schemaName;

    CreateSchemaConstantAction(String string, String string2) {
        this.schemaName = string;
        this.aid = string2;
    }

    public String toString() {
        return "CREATE SCHEMA " + this.schemaName;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        TransactionController transactionController = activation.getLanguageConnectionContext().getTransactionExecute();
        this.executeConstantActionMinion(activation, transactionController);
    }

    public void executeConstantAction(Activation activation, TransactionController transactionController) throws StandardException {
        this.executeConstantActionMinion(activation, transactionController);
    }

    private void executeConstantActionMinion(Activation activation, TransactionController transactionController) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(this.schemaName, languageConnectionContext.getTransactionExecute(), false);
        if (schemaDescriptor != null && schemaDescriptor.getUUID() != null) {
            throw StandardException.newException((String)"X0Y68.S", (Object[])new Object[]{"Schema", this.schemaName});
        }
        UUID uUID = dataDictionary.getUUIDFactory().createUUID();
        String string = this.aid;
        if (string == null) {
            string = languageConnectionContext.getCurrentUserId(activation);
        }
        dataDictionary.startWriting(languageConnectionContext);
        schemaDescriptor = dataDescriptorGenerator.newSchemaDescriptor(this.schemaName, string, uUID);
        dataDictionary.addDescriptor(schemaDescriptor, null, 3, false, transactionController);
    }
}

