/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.init;

import com.datical.liquibase.ext.checks.config.cli.FilenameGetter;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.configuration.ConfiguredValue;
import liquibase.exception.CommandExecutionException;
import liquibase.util.FileUtil;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtil;

public class InitProjectUtil {
    public static final String SQL = "sql";
    public static final String JSON = "json";
    public static final String YML = "yml";
    public static final String YAML = "yaml";
    public static final String XML = "xml";

    public static void createProjectDirectory(File object) {
        if (!(((File)object).exists() || ((File)object).mkdirs() || ((File)object).exists())) {
            object = "Unable to create specified project directory '" + ((File)object).getAbsolutePath() + "'.\nPlease check permission and try 'liquibase init project' again";
            throw new CommandExecutionException((String)object);
        }
    }

    public static void validateChangelogFilePath(String string) {
        new FilenameGetter().validate(string);
    }

    public static void validateProjectDirectory(File object) {
        if (((File)object).exists() && ((File)object).isFile()) {
            object = System.lineSeparator() + System.lineSeparator() + "The specified project directory '" + ((File)object).getAbsolutePath() + "' cannot be a file" + System.lineSeparator() + System.lineSeparator();
            throw new CommandExecutionException((String)object);
        }
    }

    public static void updateDefaultsFile(File object, boolean bl2, String string, ConfiguredValue<String> object2, ConfiguredValue<String> configuredValue, ConfiguredValue<String> configuredValue2, ConfiguredValue<String> configuredValue3, boolean bl3) {
        String string2 = FileUtil.getContents((File)object);
        if (string2 == null) {
            return;
        }
        String string3 = string2;
        if (bl3) {
            if (!((ConfiguredValue)object2).wasDefaultValueUsed()) {
                if (!((String)(object2 = ((ConfiguredValue)object2).getValue())).contains(".".concat(String.valueOf(string)))) {
                    object2 = (String)object2 + "." + string;
                }
                string3 = InitProjectUtil.replaceProperty("changeLogFile", (String)object2, string3);
            } else if (string.equalsIgnoreCase(YML)) {
                string3 = InitProjectUtil.replaceProperty("changeLogFile", "example-changelog.yml", string3);
            }
        } else {
            string3 = InitProjectUtil.replaceProperty("changeLogFile", "", string3, true);
        }
        if (!configuredValue.wasDefaultValueUsed()) {
            string3 = InitProjectUtil.replaceProperty("url", configuredValue, string3);
        }
        if (!configuredValue2.wasDefaultValueUsed()) {
            string3 = InitProjectUtil.replaceProperty("username", configuredValue2, string3);
        }
        if (!configuredValue3.wasDefaultValueUsed()) {
            string3 = InitProjectUtil.replaceProperty("password", configuredValue3, string3);
        }
        if (bl2 || string2.equals(string3)) {
            FileUtil.write(string3, (File)object, false);
            return;
        }
        boolean bl4 = InitProjectUtil.makeBackup((File)object, string2);
        FileUtil.write(string3, (File)object, false);
        if (bl4) {
            object = String.format("%sThe defaults file '%s' was backed up and then updated with your supplied values.%s", System.lineSeparator(), ((File)object).getAbsolutePath().replaceAll("\\./", "").replaceAll("\\.\\\\", ""), System.lineSeparator());
            Scope.getCurrentScope().getUI().sendMessage((String)object);
            Scope.getCurrentScope().getLog(InitProjectUtil.class).info((String)object);
        }
    }

    public static String replaceProperty(String string, ConfiguredValue<String> configuredValue, String string2) {
        return InitProjectUtil.replaceProperty(string, configuredValue.getValue(), string2);
    }

    public static String replaceProperty(String string, String string2, String string3) {
        return InitProjectUtil.replaceProperty(string, string2, string3, false);
    }

    public static String replaceProperty(String string, String string2, String string3, boolean bl2) {
        boolean bl3;
        String string4 = string3;
        Matcher matcher = Pattern.compile("^[\\s]*liquibase\\.command\\." + string + "[\\s]*[=:][\\s]*", 42).matcher(string3.toLowerCase());
        boolean bl4 = bl3 = string.toLowerCase().contains("username") || string.toLowerCase().contains("password");
        if (matcher.find()) {
            string3 = string2;
            if (bl3) {
                string3 = "*****";
            }
            if (string3 != null) {
                string3 = string3.trim();
            }
            Scope.getCurrentScope().getLog(InitProjectUtil.class).info("Replacing value for 'liquibase.command." + string + "' with '" + string3 + "'");
            string4 = string4.replaceAll("liquibase\\.command\\.(?i)" + string + "[\\s]*([=:])[\\s]*(.*)", (bl2 ? "#" : "") + "liquibase.command." + string + "$1" + (string2 == null ? string2 : Matcher.quoteReplacement(string2))).replace("liquibase.command." + string + ":" + string2, "liquibase.command." + string + ": " + string2);
        } else if (Pattern.compile("^[\\s]*(?i)" + string + "[\\s]*[=:][\\s]*", 42).matcher(string3.toLowerCase()).find()) {
            string3 = string2;
            if (bl3) {
                string3 = "*****";
            }
            if (string3 != null) {
                string3 = string3.trim();
            }
            string4 = string4.replaceAll("(?i)" + string + "[\\s]*([=:])[\\s]*(.*)", (bl2 ? "#" : "") + string + "$1" + (string2 == null ? string2 : Matcher.quoteReplacement(string2)));
            Scope.getCurrentScope().getLog(InitProjectUtil.class).info("Replacing value for '" + string + "' with '" + string3 + "'");
            string4 = string4.replace(string + ":" + string2, string + ": " + string2);
        } else {
            string3 = string2;
            Scope.getCurrentScope().getLog(InitProjectUtil.class).info("Adding property 'liquibase.command." + string + "' with value '" + string3 + "'");
            string4 = string4 + "\nliquibase.command." + string + "=" + string2;
        }
        return string4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File copyExampleProperties(String object, String string, String string2) {
        try {
            Object object2;
            Object object3;
            block17: {
                if (object == null || ((String)object).equalsIgnoreCase(SQL)) {
                    object = "liquibase/examples/sql/liquibase.properties";
                } else if (((String)object).equalsIgnoreCase(XML)) {
                    object = "liquibase/examples/xml/liquibase.properties";
                } else if (((String)object).equalsIgnoreCase(JSON)) {
                    object = "liquibase/examples/json/liquibase.properties";
                } else {
                    if (!((String)object).equalsIgnoreCase(YAML)) {
                        if (!((String)object).equalsIgnoreCase(YML)) throw new CommandExecutionException("Unknown format '" + (String)object + "'");
                    }
                    object = "liquibase/examples/yaml/liquibase.properties";
                }
                object3 = InitProjectUtil.class.getClassLoader().getResourceAsStream((String)object);
                object2 = null;
                try {
                    object = StreamUtil.readStreamAsString((InputStream)object3);
                    if (object3 == null) break block17;
                }
                catch (Throwable throwable) {
                    try {
                        object = throwable;
                        object2 = throwable;
                        throw object;
                    }
                    catch (Throwable throwable2) {
                        if (object3 == null) throw throwable2;
                        if (object2 == null) {
                            ((InputStream)object3).close();
                            throw throwable2;
                        }
                        try {
                            ((InputStream)object3).close();
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            ((Throwable)object2).addSuppressed(throwable3);
                            throw throwable2;
                        }
                    }
                }
                ((InputStream)object3).close();
            }
            if (StringUtil.isEmpty((String)object)) {
                throw new CommandExecutionException("Unable to read the example changelog file resource.");
            }
            object3 = new File(string, string2);
            FileUtil.write((String)object, (File)object3, false);
            object2 = ((File)object3).getAbsolutePath().replaceAll("\\./", "").replaceAll("\\.\\\\", "");
            object = "Created example defaults file '" + (String)object2 + "'" + System.lineSeparator();
            Scope.getCurrentScope().getLog(InitProjectUtil.class).info((String)object);
            Scope.getCurrentScope().getUI().sendMessage((String)object);
            return object3;
        }
        catch (IOException iOException) {
            throw new CommandExecutionException("Unable to create the example properties file", iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean copyExampleChangelog(String object, File file, String string, ConfiguredValue<String> configuredValue) {
        try {
            String string2;
            Object object2;
            Object object3;
            block19: {
                File[] fileArray = InitProjectUtil.findChangeLogsInProjectDir(file);
                if (string != null && fileArray != null && fileArray.length > 0) {
                    object3 = new File(file, string);
                    if (Arrays.stream(fileArray).anyMatch(arg_0 -> InitProjectUtil.lambda$copyExampleChangelog$0((File)object3, arg_0))) {
                        return false;
                    }
                }
                if (((String)object).equalsIgnoreCase(SQL)) {
                    object3 = "liquibase/examples/sql/example-changelog.sql";
                } else if (((String)object).equalsIgnoreCase(XML)) {
                    object3 = "liquibase/examples/xml/example-changelog.xml";
                } else if (((String)object).equalsIgnoreCase(JSON)) {
                    object3 = "liquibase/examples/json/example-changelog.json";
                } else {
                    if (!((String)object).equalsIgnoreCase(YAML)) {
                        if (!((String)object).equalsIgnoreCase(YML)) throw new CommandExecutionException("Unknown format '" + (String)object + "'");
                    }
                    object3 = "liquibase/examples/yaml/example-changelog.yaml";
                }
                object3 = InitProjectUtil.class.getClassLoader().getResourceAsStream((String)object3);
                object2 = null;
                try {
                    string2 = StreamUtil.readStreamAsString((InputStream)object3);
                    if (object3 == null) break block19;
                }
                catch (Throwable throwable) {
                    try {
                        object = throwable;
                        object2 = throwable;
                        throw object;
                    }
                    catch (Throwable throwable2) {
                        if (object3 == null) throw throwable2;
                        if (object2 == null) {
                            ((InputStream)object3).close();
                            throw throwable2;
                        }
                        try {
                            ((InputStream)object3).close();
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            ((Throwable)object2).addSuppressed(throwable3);
                            throw throwable2;
                        }
                    }
                }
                ((InputStream)object3).close();
            }
            if (StringUtil.isEmpty(string2)) {
                throw new CommandExecutionException("Unable to read the example changelog file resource.");
            }
            object3 = string != null && !configuredValue.wasDefaultValueUsed() ? (string.contains(".".concat(String.valueOf(object))) ? new File(file, string) : new File(file, string + "." + (String)object)) : new File(file, "example-changelog.".concat(String.valueOf(object)));
            FileUtil.write(string2, (File)object3, false);
            object2 = ((File)object3).getAbsolutePath().replaceAll("\\./", "").replaceAll("\\.\\\\", "");
            object = System.lineSeparator() + "Created example changelog file '" + (String)object2 + "'";
            Scope.getCurrentScope().getLog(InitProjectUtil.class).info((String)object);
            Scope.getCurrentScope().getUI().sendMessage((String)object);
            return true;
        }
        catch (IOException iOException) {
            throw new CommandExecutionException("Unable to create the example changelog", iOException);
        }
    }

    public static File determineExamplesFolder() {
        Object object;
        try {
            object = InitProjectUtil.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            if (object == null) {
                throw new CommandExecutionException("Unable to determine URI for liquibase.jar");
            }
            if (!new File((String)object).exists()) {
                throw new CommandExecutionException("Unable to locate liquibase.jar at path '" + (String)object + "'");
            }
            object = new File((String)object);
            object = new File(((File)object).getParentFile(), "examples");
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new CommandExecutionException("Error creating URI for '" + InitProjectUtil.class.getName() + "'", uRISyntaxException);
        }
        return object;
    }

    public static String determineFormatType(String string, String string2) {
        if ((string = InitProjectUtil.getExtension(string)) == null) {
            if (string2 != null) {
                return string2;
            }
            return null;
        }
        switch (string) {
            case "sql": 
            case "json": 
            case "yml": 
            case "yaml": 
            case "xml": {
                return string;
            }
        }
        return null;
    }

    public static String getExtension(String stringArray) {
        if (stringArray.isEmpty()) {
            return null;
        }
        if ((stringArray = stringArray.split("\\.")).length == 1) {
            return null;
        }
        return stringArray[stringArray.length - 1].toLowerCase();
    }

    public static File[] findChangeLogsInProjectDir(File file2) {
        FileFilter fileFilter = file -> !file.isDirectory() && file.getName().toLowerCase().contains("changelog") && InitProjectUtil.hasRecognizedExtension(file);
        return file2.listFiles(fileFilter);
    }

    public static boolean hasRecognizedExtension(File file) {
        return InitProjectUtil.determineFormatType(file.getName(), null) != null;
    }

    private static String pad(String string, String string2) {
        return string + string2.replaceFirst(":", ": ");
    }

    private static boolean makeBackup(File object, String string) {
        try {
            File file = InitProjectUtil.calcBackupFile((File)object);
            FileUtil.write(string, file);
            return true;
        }
        catch (IOException iOException) {
            object = "Unable to make a backup copy of the defaults file '" + ((File)object).getAbsolutePath() + "'.\nNo changes will be made to the existing defaults file";
            Scope.getCurrentScope().getUI().sendErrorMessage("WARNING: ".concat(String.valueOf(object)));
            Scope.getCurrentScope().getLog(InitProjectUtil.class).warning((String)object);
            return false;
        }
    }

    private static File calcBackupFile(File file) {
        int n2 = 1;
        File file2 = new File(file.getParentFile(), file.getName() + ".backup." + InitProjectUtil.newVersion(1));
        boolean bl2 = true;
        while (bl2) {
            bl2 = file2.exists();
            if (!bl2) {
                bl2 = false;
                continue;
            }
            file2 = new File(file.getParentFile(), file.getName() + ".backup." + InitProjectUtil.newVersion(++n2));
        }
        return file2;
    }

    private static String newVersion(int n2) {
        if (n2 < 10) {
            return "0" + Integer.toString(n2);
        }
        return Integer.toString(n2);
    }

    private static /* synthetic */ boolean lambda$copyExampleChangelog$0(File file, File file2) {
        return file2.getAbsolutePath().equalsIgnoreCase(file.getAbsolutePath());
    }
}

