/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.jcr.nodetype;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.webdav.jcr.nodetype.NodeTypeConstants;
import org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NodeTypeProperty
extends AbstractDavProperty
implements NodeTypeConstants {
    private static Logger log = LoggerFactory.getLogger((Class)NodeTypeProperty.class);
    private final Set nodetypeNames = new HashSet();

    public NodeTypeProperty(DavPropertyName name, NodeType nodeType, boolean isProtected) {
        this(name, new NodeType[]{nodeType}, isProtected);
    }

    public NodeTypeProperty(DavPropertyName name, NodeType[] nodeTypes, boolean isProtected) {
        super(name, isProtected);
        for (int i = 0; i < nodeTypes.length; ++i) {
            NodeType nt = nodeTypes[i];
            if (nt == null) continue;
            this.nodetypeNames.add(nodeTypes[i].getName());
        }
    }

    public NodeTypeProperty(DavPropertyName name, String[] nodeTypeNames, boolean isProtected) {
        super(name, isProtected);
        for (int i = 0; i < nodeTypeNames.length; ++i) {
            if (nodeTypeNames[i] == null) continue;
            this.nodetypeNames.add(nodeTypeNames[i]);
        }
    }

    public NodeTypeProperty(DavProperty property) {
        super(property.getName(), property.isInvisibleInAllprop());
        if (property instanceof NodeTypeProperty) {
            this.nodetypeNames.addAll(((NodeTypeProperty)property).nodetypeNames);
        } else {
            Object propValue = property.getValue();
            if (propValue instanceof List) {
                this.retrieveNodeTypeNames((List)propValue);
            } else if (propValue instanceof Element) {
                ArrayList<Object> l = new ArrayList<Object>();
                l.add(propValue);
                this.retrieveNodeTypeNames(l);
            } else {
                log.debug("NodeTypeProperty '" + property.getName() + "' has no/unparsable value.");
            }
        }
    }

    private void retrieveNodeTypeNames(List elementList) {
        Iterator it = elementList.iterator();
        while (it.hasNext()) {
            Object content = it.next();
            if (!(content instanceof Element)) continue;
            Element el = (Element)content;
            if ("nodetype".equals(el.getLocalName()) && NodeTypeConstants.NAMESPACE.isSame(el.getNamespaceURI())) {
                String nodetypeName = DomUtil.getChildText(el, "nodetypename", NodeTypeConstants.NAMESPACE);
                if (nodetypeName == null || "".equals(nodetypeName)) continue;
                this.nodetypeNames.add(nodetypeName);
                continue;
            }
            log.debug("'dcr:nodetype' element expected -> ignoring element '" + ((Element)content).getNodeName() + "'");
        }
    }

    public Set getNodeTypeNames() {
        return this.nodetypeNames;
    }

    public Object getValue() {
        return this.nodetypeNames;
    }

    public Element toXml(Document document) {
        Element elem = this.getName().toXml(document);
        Iterator it = this.getNodeTypeNames().iterator();
        while (it.hasNext()) {
            String name = it.next().toString();
            Element ntElem = DomUtil.addChildElement(elem, "nodetype", NodeTypeConstants.NAMESPACE);
            DomUtil.addChildElement(ntElem, "nodetypename", NodeTypeConstants.NAMESPACE, name);
        }
        return elem;
    }
}

