/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.AsciiString;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.FutureMono;
import reactor.netty.NettyOutbound;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.AbortedException;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.HttpOperations;
import reactor.netty.http.server.ConnectionInfo;
import reactor.netty.http.server.HttpServerFormDecoderProvider;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import reactor.netty.http.server.HttpServerState;
import reactor.netty.http.server.ServerCookies;
import reactor.netty.http.server.SimpleCompressionHandler;
import reactor.netty.http.server.WebsocketServerOperations;
import reactor.netty.http.server.WebsocketServerSpec;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

class HttpServerOperations
extends HttpOperations<HttpServerRequest, HttpServerResponse>
implements HttpServerRequest,
HttpServerResponse {
    final BiPredicate<HttpServerRequest, HttpServerResponse> compressionPredicate;
    final ConnectionInfo connectionInfo;
    final ServerCookieDecoder cookieDecoder;
    final ServerCookieEncoder cookieEncoder;
    final ServerCookies cookieHolder;
    final HttpServerFormDecoderProvider formDecoderProvider;
    final BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle;
    final HttpRequest nettyRequest;
    final HttpResponse nettyResponse;
    final String path;
    final HttpHeaders responseHeaders;
    final String scheme;
    Function<? super String, Map<String, String>> paramsResolver;
    Consumer<? super HttpHeaders> trailerHeadersConsumer;
    static final Logger log = Loggers.getLogger(HttpServerOperations.class);
    static final AsciiString EVENT_STREAM = new AsciiString((CharSequence)"text/event-stream");
    static final FullHttpResponse CONTINUE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, Unpooled.EMPTY_BUFFER);

    HttpServerOperations(HttpServerOperations replaced) {
        super(replaced);
        this.compressionPredicate = replaced.compressionPredicate;
        this.connectionInfo = replaced.connectionInfo;
        this.cookieDecoder = replaced.cookieDecoder;
        this.cookieEncoder = replaced.cookieEncoder;
        this.cookieHolder = replaced.cookieHolder;
        this.formDecoderProvider = replaced.formDecoderProvider;
        this.mapHandle = replaced.mapHandle;
        this.nettyRequest = replaced.nettyRequest;
        this.nettyResponse = replaced.nettyResponse;
        this.paramsResolver = replaced.paramsResolver;
        this.path = replaced.path;
        this.responseHeaders = replaced.responseHeaders;
        this.scheme = replaced.scheme;
        this.trailerHeadersConsumer = replaced.trailerHeadersConsumer;
    }

    HttpServerOperations(Connection c, ConnectionObserver listener, HttpRequest nettyRequest, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressionPredicate, @Nullable ConnectionInfo connectionInfo, ServerCookieDecoder decoder, ServerCookieEncoder encoder, HttpServerFormDecoderProvider formDecoderProvider, @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle, boolean secured) {
        this(c, listener, nettyRequest, compressionPredicate, connectionInfo, decoder, encoder, formDecoderProvider, mapHandle, true, secured);
    }

    HttpServerOperations(Connection c, ConnectionObserver listener, HttpRequest nettyRequest, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressionPredicate, @Nullable ConnectionInfo connectionInfo, ServerCookieDecoder decoder, ServerCookieEncoder encoder, HttpServerFormDecoderProvider formDecoderProvider, @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle, boolean resolvePath, boolean secured) {
        super(c, listener);
        this.compressionPredicate = compressionPredicate;
        this.connectionInfo = connectionInfo;
        this.cookieDecoder = decoder;
        this.cookieEncoder = encoder;
        this.cookieHolder = ServerCookies.newServerRequestHolder(nettyRequest.headers(), decoder);
        this.formDecoderProvider = formDecoderProvider;
        this.mapHandle = mapHandle;
        this.nettyRequest = nettyRequest;
        this.nettyResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        this.path = resolvePath ? HttpServerOperations.resolvePath(nettyRequest.uri()) : null;
        this.responseHeaders = this.nettyResponse.headers();
        this.responseHeaders.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        this.scheme = secured ? "https" : "http";
    }

    @Override
    public NettyOutbound sendHeaders() {
        if (this.hasSentHeaders()) {
            return this;
        }
        return this.then((Publisher)Mono.empty());
    }

    @Override
    public HttpServerOperations withConnection(Consumer<? super Connection> withConnection) {
        Objects.requireNonNull(withConnection, "withConnection");
        withConnection.accept((Connection)this);
        return this;
    }

    @Override
    protected HttpMessage newFullBodyMessage(ByteBuf body) {
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(this.version(), this.status(), body);
        if (!HttpMethod.HEAD.equals((Object)this.method())) {
            this.responseHeaders.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            if (!HttpResponseStatus.NOT_MODIFIED.equals((Object)this.status()) && HttpUtil.getContentLength((HttpMessage)this.nettyResponse, (int)-1) == -1) {
                this.responseHeaders.setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, body.readableBytes());
            }
        } else if (HttpUtil.getContentLength((HttpMessage)this.nettyResponse, (int)-1) != -1) {
            this.responseHeaders.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
        }
        res.headers().set(this.responseHeaders);
        return res;
    }

    @Override
    public HttpServerResponse addCookie(Cookie cookie) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.responseHeaders.add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)this.cookieEncoder.encode(cookie));
        return this;
    }

    @Override
    public HttpServerResponse addHeader(CharSequence name, CharSequence value) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.responseHeaders.add(name, (Object)value);
        return this;
    }

    @Override
    public HttpServerOperations chunkedTransfer(boolean chunked) {
        if (!this.hasSentHeaders() && HttpUtil.isTransferEncodingChunked((HttpMessage)this.nettyResponse) != chunked) {
            this.responseHeaders.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            HttpUtil.setTransferEncodingChunked((HttpMessage)this.nettyResponse, (boolean)chunked);
        }
        return this;
    }

    @Override
    public Map<CharSequence, Set<Cookie>> cookies() {
        if (this.cookieHolder != null) {
            return this.cookieHolder.getCachedCookies();
        }
        throw new IllegalStateException("request not parsed");
    }

    @Override
    public Map<CharSequence, List<Cookie>> allCookies() {
        if (this.cookieHolder != null) {
            return this.cookieHolder.getAllCachedCookies();
        }
        throw new IllegalStateException("request not parsed");
    }

    @Override
    public HttpServerResponse header(CharSequence name, CharSequence value) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.responseHeaders.set(name, (Object)value);
        return this;
    }

    @Override
    public HttpServerResponse headers(HttpHeaders headers) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.responseHeaders.set(headers);
        return this;
    }

    @Override
    public boolean isFormUrlencoded() {
        String contentType = this.requestHeaders().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        return HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.contentEqualsIgnoreCase((CharSequence)contentType);
    }

    @Override
    public boolean isKeepAlive() {
        return HttpUtil.isKeepAlive((HttpMessage)this.nettyRequest);
    }

    @Override
    public boolean isMultipart() {
        return HttpPostRequestDecoder.isMultipart((HttpRequest)this.nettyRequest);
    }

    @Override
    public boolean isWebsocket() {
        return HttpServerOperations.get((Channel)this.channel()) instanceof WebsocketServerOperations;
    }

    final boolean isHttp2() {
        return this.requestHeaders().contains((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text());
    }

    @Override
    public HttpServerResponse keepAlive(boolean keepAlive) {
        HttpUtil.setKeepAlive((HttpMessage)this.nettyResponse, (boolean)keepAlive);
        return this;
    }

    @Override
    public HttpMethod method() {
        return this.nettyRequest.method();
    }

    @Override
    @Nullable
    public String param(CharSequence key) {
        Objects.requireNonNull(key, "key");
        Map<String, String> params = null;
        if (this.paramsResolver != null) {
            params = this.paramsResolver.apply(this.uri());
        }
        return null != params ? params.get(key.toString()) : null;
    }

    @Override
    @Nullable
    public Map<String, String> params() {
        return null != this.paramsResolver ? this.paramsResolver.apply(this.uri()) : null;
    }

    @Override
    public HttpServerRequest paramsResolver(Function<? super String, Map<String, String>> paramsResolver) {
        this.paramsResolver = paramsResolver;
        return this;
    }

    @Override
    public Flux<HttpData> receiveForm() {
        return this.receiveFormInternal(this.formDecoderProvider);
    }

    @Override
    public Flux<HttpData> receiveForm(Consumer<HttpServerFormDecoderProvider.Builder> formDecoderBuilder) {
        Objects.requireNonNull(formDecoderBuilder, "formDecoderBuilder");
        HttpServerFormDecoderProvider.Build builder = new HttpServerFormDecoderProvider.Build();
        formDecoderBuilder.accept(builder);
        HttpServerFormDecoderProvider config = builder.build();
        return this.receiveFormInternal(config);
    }

    public Flux<?> receiveObject() {
        if (HttpUtil.is100ContinueExpected((HttpMessage)this.nettyRequest)) {
            return FutureMono.deferFuture(() -> {
                if (!this.hasSentHeaders()) {
                    return this.channel().writeAndFlush((Object)CONTINUE);
                }
                return this.channel().newSucceededFuture();
            }).thenMany((Publisher)super.receiveObject());
        }
        return super.receiveObject();
    }

    @Override
    @Nullable
    public InetSocketAddress hostAddress() {
        if (this.connectionInfo != null) {
            return this.connectionInfo.getHostAddress();
        }
        return null;
    }

    @Override
    @Nullable
    public InetSocketAddress remoteAddress() {
        if (this.connectionInfo != null) {
            return this.connectionInfo.getRemoteAddress();
        }
        return null;
    }

    @Override
    public HttpHeaders requestHeaders() {
        if (this.nettyRequest != null) {
            return this.nettyRequest.headers();
        }
        throw new IllegalStateException("request not parsed");
    }

    @Override
    public String scheme() {
        if (this.connectionInfo != null) {
            return this.connectionInfo.getScheme();
        }
        return this.scheme;
    }

    @Override
    public HttpHeaders responseHeaders() {
        return this.responseHeaders;
    }

    @Override
    public Mono<Void> send() {
        if (this.markSentHeaderAndBody(new Object[0])) {
            HttpMessage response = this.newFullBodyMessage(Unpooled.EMPTY_BUFFER);
            return FutureMono.deferFuture(() -> this.channel().writeAndFlush((Object)response));
        }
        return Mono.empty();
    }

    public NettyOutbound sendFile(Path file) {
        try {
            return this.sendFile(file, 0L, Files.size(file));
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format((Channel)this.channel(), (String)"Path not resolved"), (Throwable)e);
            }
            return this.then((Publisher)this.sendNotFound());
        }
    }

    @Override
    public Mono<Void> sendNotFound() {
        return this.status(HttpResponseStatus.NOT_FOUND).send();
    }

    @Override
    public Mono<Void> sendRedirect(String location) {
        Objects.requireNonNull(location, "location");
        return this.status(HttpResponseStatus.FOUND).header((CharSequence)HttpHeaderNames.LOCATION, location).send();
    }

    @Override
    public HttpServerResponse sse() {
        this.header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)EVENT_STREAM);
        return this;
    }

    @Override
    public HttpResponseStatus status() {
        return this.nettyResponse.status();
    }

    @Override
    public HttpServerResponse status(HttpResponseStatus status) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.nettyResponse.setStatus(status);
        return this;
    }

    @Override
    public HttpServerResponse trailerHeaders(Consumer<? super HttpHeaders> trailerHeaders) {
        this.trailerHeadersConsumer = Objects.requireNonNull(trailerHeaders, "trailerHeaders");
        return this;
    }

    @Override
    public Mono<Void> sendWebsocket(BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> websocketHandler, WebsocketServerSpec configurer) {
        return this.withWebsocketSupport(this.uri(), configurer, websocketHandler);
    }

    @Override
    public String uri() {
        if (this.nettyRequest != null) {
            return this.nettyRequest.uri();
        }
        throw new IllegalStateException("request not parsed");
    }

    @Override
    public String fullPath() {
        if (this.path != null) {
            return this.path;
        }
        throw new IllegalStateException("request not parsed");
    }

    @Override
    public HttpVersion version() {
        if (this.nettyRequest != null) {
            return this.nettyRequest.protocolVersion();
        }
        throw new IllegalStateException("request not parsed");
    }

    @Override
    public HttpServerResponse compression(boolean compress) {
        if (!compress) {
            this.removeHandler("reactor.left.compressionHandler");
        } else if (this.channel().pipeline().get("reactor.left.compressionHandler") == null) {
            SimpleCompressionHandler handler = new SimpleCompressionHandler();
            try {
                handler.decode(this.channel().pipeline().context("reactor.right.reactiveBridge"), this.nettyRequest);
                this.addHandlerFirst("reactor.left.compressionHandler", (ChannelHandler)handler);
            }
            catch (Throwable e) {
                log.error(ReactorNetty.format((Channel)this.channel(), (String)""), e);
            }
        }
        return this;
    }

    protected void onInboundNext(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpRequest) {
            try {
                this.listener().onStateChange((Connection)this, (ConnectionObserver.State)HttpServerState.REQUEST_RECEIVED);
            }
            catch (Exception e) {
                this.onInboundError(e);
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            if (msg instanceof FullHttpRequest) {
                FullHttpRequest request = (FullHttpRequest)msg;
                if (request.content().readableBytes() > 0) {
                    super.onInboundNext(ctx, msg);
                } else {
                    request.release();
                }
                if (this.isHttp2()) {
                    this.channel().config().setAutoRead(true);
                    this.onInboundComplete();
                }
            }
            return;
        }
        if (msg instanceof HttpContent) {
            if (msg != LastHttpContent.EMPTY_LAST_CONTENT) {
                super.onInboundNext(ctx, msg);
            }
            if (msg instanceof LastHttpContent) {
                this.channel().config().setAutoRead(true);
                this.onInboundComplete();
            }
        } else {
            super.onInboundNext(ctx, msg);
        }
    }

    protected void onInboundClose() {
        this.discardWhenNoReceiver();
        if (!this.isInboundCancelled() && !this.isInboundDisposed()) {
            this.onInboundError((Throwable)new AbortedException("Connection has been closed"));
        }
        this.terminate();
    }

    @Override
    protected void afterMarkSentHeaders() {
        if (HttpResponseStatus.NOT_MODIFIED.equals((Object)this.status())) {
            this.responseHeaders.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING).remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        }
        if (this.compressionPredicate != null && this.compressionPredicate.test(this, this)) {
            this.compression(true);
        }
    }

    @Override
    protected void beforeMarkSentHeaders() {
    }

    @Override
    protected void onHeadersSent() {
    }

    protected void onOutboundComplete() {
        ChannelFuture f;
        if (this.isWebsocket()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format((Channel)this.channel(), (String)"Last HTTP response frame"));
        }
        if (this.markSentHeaderAndBody(new Object[0])) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format((Channel)this.channel(), (String)"No sendHeaders() called before complete, sending zero-length header"));
            }
            f = this.channel().writeAndFlush((Object)this.newFullBodyMessage(Unpooled.EMPTY_BUFFER));
        } else if (this.markSentBody()) {
            String declaredHeaderNames;
            LastHttpContent lastHttpContent = LastHttpContent.EMPTY_LAST_CONTENT;
            if (this.trailerHeadersConsumer != null && HttpUtil.isTransferEncodingChunked((HttpMessage)this.nettyResponse) && (declaredHeaderNames = this.responseHeaders.get((CharSequence)HttpHeaderNames.TRAILER)) != null) {
                TrailerHeaders trailerHeaders = new TrailerHeaders(declaredHeaderNames);
                try {
                    this.trailerHeadersConsumer.accept((HttpHeaders)trailerHeaders);
                }
                catch (IllegalArgumentException e) {
                    log.error(ReactorNetty.format((Channel)this.channel(), (String)"Cannot apply trailer headers [{0}]"), new Object[]{declaredHeaderNames, e});
                }
                if (!trailerHeaders.isEmpty()) {
                    lastHttpContent = new DefaultLastHttpContent();
                    lastHttpContent.trailingHeaders().set((HttpHeaders)trailerHeaders);
                }
            }
            f = this.channel().writeAndFlush((Object)lastHttpContent);
        } else {
            this.discard();
            return;
        }
        f.addListener(s -> {
            this.discard();
            if (!s.isSuccess() && log.isDebugEnabled()) {
                log.debug(ReactorNetty.format((Channel)this.channel(), (String)"Failed flushing last frame"), s.cause());
            }
        });
    }

    static void cleanHandlerTerminate(Channel ch) {
        ChannelOperations ops = HttpServerOperations.get((Channel)ch);
        if (ops == null) {
            return;
        }
        ops.discard();
        if (!ops.isSubscriptionDisposed()) {
            ch.eventLoop().execute(() -> ((HttpServerOperations)((HttpServerOperations)ops)).terminate());
        } else {
            ((HttpServerOperations)ops).terminate();
        }
    }

    static long requestsCounter(Channel channel) {
        HttpServerOperations ops = (HttpServerOperations)Connection.from((Channel)channel).as(HttpServerOperations.class);
        if (ops == null) {
            return -1L;
        }
        return ((AtomicLong)ops.connection()).get();
    }

    static void sendDecodingFailures(ChannelHandlerContext ctx, ConnectionObserver listener, boolean secure, Throwable t, Object msg) {
        Throwable cause;
        Connection conn = Connection.from((Channel)ctx.channel());
        Throwable throwable = cause = t.getCause() != null ? t.getCause() : t;
        if (log.isWarnEnabled()) {
            log.warn(ReactorNetty.format((Channel)ctx.channel(), (String)("Decoding failed: " + msg + " : ")), cause);
        }
        ReferenceCountUtil.release((Object)msg);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_0, cause instanceof TooLongFrameException ? HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE : HttpResponseStatus.BAD_REQUEST);
        response.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, 0).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        HttpRequest request = null;
        if (msg instanceof HttpRequest) {
            request = (HttpRequest)msg;
        }
        listener.onStateChange((Connection)new FailedHttpServerRequest(conn, listener, request, (HttpResponse)response, secure), (ConnectionObserver.State)HttpServerState.REQUEST_DECODING_FAILED);
    }

    protected void onOutboundError(Throwable err) {
        if (!this.channel().isActive()) {
            super.onOutboundError(err);
            return;
        }
        if (this.markSentHeaders(new Object[0])) {
            log.error(ReactorNetty.format((Channel)this.channel(), (String)"Error starting response. Replying error status"), err);
            this.nettyResponse.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            this.responseHeaders.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            this.channel().writeAndFlush((Object)this.newFullBodyMessage(Unpooled.EMPTY_BUFFER)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        this.markSentBody();
        log.error(ReactorNetty.format((Channel)this.channel(), (String)"Error finishing response. Closing connection"), err);
        this.channel().writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    @Override
    protected HttpMessage outboundHttpMessage() {
        return this.nettyResponse;
    }

    final Flux<HttpData> receiveFormInternal(HttpServerFormDecoderProvider config) {
        boolean isMultipart = this.isMultipart();
        if (!Objects.equals(this.method(), HttpMethod.POST) || !this.isFormUrlencoded() && !isMultipart) {
            return Flux.error((Throwable)new IllegalStateException("Request is not POST or does not have Content-Type with value 'application/x-www-form-urlencoded' or 'multipart/form-data'"));
        }
        return Flux.defer(() -> config.newHttpPostRequestDecoder(this.nettyRequest, isMultipart).flatMapMany(decoder -> this.receiveObject().concatMap(object -> {
            if (!(object instanceof HttpContent)) {
                return Mono.empty();
            }
            HttpContent httpContent = (HttpContent)object;
            if (config.maxInMemorySize > -1L) {
                httpContent.retain();
            }
            return config.maxInMemorySize == -1L ? Flux.using(() -> decoder.offer(httpContent), d -> Flux.fromIterable(decoder.currentHttpData(!config.streaming)), d -> decoder.cleanCurrentHttpData(!config.streaming)) : Flux.usingWhen((Publisher)Mono.fromCallable(() -> decoder.offer(httpContent)).subscribeOn(config.scheduler).doFinally(sig -> httpContent.release()), d -> Flux.fromIterable(decoder.currentHttpData(true)), d -> Mono.fromRunnable(() -> decoder.cleanCurrentHttpData(true)));
        }, 0).doFinally(sig -> decoder.destroy())));
    }

    final Mono<Void> withWebsocketSupport(String url, WebsocketServerSpec websocketServerSpec, BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> websocketHandler) {
        Objects.requireNonNull(websocketServerSpec, "websocketServerSpec");
        Objects.requireNonNull(websocketHandler, "websocketHandler");
        if (this.markSentHeaders(new Object[0])) {
            WebsocketServerOperations ops = new WebsocketServerOperations(url, websocketServerSpec, this);
            return FutureMono.from((Future)ops.handshakerResult).doOnEach(signal -> {
                if (!(signal.hasError() || websocketServerSpec.protocols() != null && ops.selectedSubprotocol() == null)) {
                    ((Publisher)websocketHandler.apply(ops, ops)).subscribe((Subscriber)new WebsocketSubscriber(ops, Context.of((ContextView)signal.getContextView())));
                }
            });
        }
        log.error(ReactorNetty.format((Channel)this.channel(), (String)"Cannot enable websocket if headers have already been sent"));
        return Mono.error((Throwable)new IllegalStateException("Failed to upgrade to websocket"));
    }

    static final class TrailerHeaders
    extends DefaultHttpHeaders {
        static final Set<String> DISALLOWED_TRAILER_HEADER_NAMES = new HashSet<String>(14);

        TrailerHeaders(String declaredHeaderNames) {
            super(true, (DefaultHeaders.NameValidator)new TrailerNameValidator(TrailerHeaders.filterHeaderNames(declaredHeaderNames)));
        }

        static Set<String> filterHeaderNames(String declaredHeaderNames) {
            String[] names;
            Objects.requireNonNull(declaredHeaderNames, "declaredHeaderNames");
            HashSet<String> result = new HashSet<String>();
            for (String name : names = declaredHeaderNames.split(",", -1)) {
                String trimmedStr = name.trim();
                if (trimmedStr.isEmpty() || DISALLOWED_TRAILER_HEADER_NAMES.contains(trimmedStr.toLowerCase(Locale.ENGLISH))) continue;
                result.add(trimmedStr);
            }
            return result;
        }

        static {
            DISALLOWED_TRAILER_HEADER_NAMES.add("age");
            DISALLOWED_TRAILER_HEADER_NAMES.add("cache-control");
            DISALLOWED_TRAILER_HEADER_NAMES.add("content-encoding");
            DISALLOWED_TRAILER_HEADER_NAMES.add("content-length");
            DISALLOWED_TRAILER_HEADER_NAMES.add("content-range");
            DISALLOWED_TRAILER_HEADER_NAMES.add("content-type");
            DISALLOWED_TRAILER_HEADER_NAMES.add("date");
            DISALLOWED_TRAILER_HEADER_NAMES.add("expires");
            DISALLOWED_TRAILER_HEADER_NAMES.add("location");
            DISALLOWED_TRAILER_HEADER_NAMES.add("retry-after");
            DISALLOWED_TRAILER_HEADER_NAMES.add("trailer");
            DISALLOWED_TRAILER_HEADER_NAMES.add("transfer-encoding");
            DISALLOWED_TRAILER_HEADER_NAMES.add("vary");
            DISALLOWED_TRAILER_HEADER_NAMES.add("warning");
        }

        static final class TrailerNameValidator
        implements DefaultHeaders.NameValidator<CharSequence> {
            final Set<String> declaredHeaderNames;

            TrailerNameValidator(Set<String> declaredHeaderNames) {
                this.declaredHeaderNames = declaredHeaderNames;
            }

            public void validateName(CharSequence name) {
                if (!this.declaredHeaderNames.contains(name.toString())) {
                    throw new IllegalArgumentException("Trailer header name [" + name + "] not declared with [Trailer] header, or it is not a valid trailer header name");
                }
            }
        }
    }

    static final class FailedHttpServerRequest
    extends HttpServerOperations {
        final HttpResponse customResponse;

        FailedHttpServerRequest(Connection c, ConnectionObserver listener, @Nullable HttpRequest nettyRequest, HttpResponse nettyResponse, boolean secure) {
            super(c, listener, nettyRequest, null, null, ServerCookieDecoder.STRICT, ServerCookieEncoder.STRICT, HttpServerFormDecoderProvider.DEFAULT_FORM_DECODER_SPEC, null, false, secure);
            this.customResponse = nettyResponse;
        }

        @Override
        protected HttpMessage outboundHttpMessage() {
            return this.customResponse;
        }

        @Override
        public HttpResponseStatus status() {
            return this.customResponse.status();
        }
    }

    static final class WebsocketSubscriber
    implements CoreSubscriber<Void>,
    ChannelFutureListener {
        final WebsocketServerOperations ops;
        final Context context;

        WebsocketSubscriber(WebsocketServerOperations ops, Context context) {
            this.ops = ops;
            this.context = context;
        }

        public void onSubscribe(Subscription s) {
            s.request(Long.MAX_VALUE);
        }

        public void onNext(Void aVoid) {
        }

        public void onError(Throwable t) {
            this.ops.onError(t);
        }

        public void operationComplete(ChannelFuture future) {
            ((HttpServerOperations)this.ops).terminate();
        }

        public void onComplete() {
            if (this.ops.channel().isActive()) {
                this.ops.sendCloseNow(new CloseWebSocketFrame(WebSocketCloseStatus.NORMAL_CLOSURE), this);
            }
        }

        public Context currentContext() {
            return this.context;
        }
    }
}

