/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config;

import org.apache.activemq.artemis.core.remoting.impl.netty.TransportConstants;

public class JMXConnectorConfiguration {
    private int rmiRegistryPort;
    private String connectorHost = "localhost";
    private int connectorPort = 1099;
    private String connectorPath = "/jmxrmi";
    private String jmxRealm = "activemq";
    private String objectName = "connector:name=rmi";
    private String authenticatorType = "password";
    private boolean secured = false;
    private String keyStoreProvider = TransportConstants.DEFAULT_KEYSTORE_PROVIDER;
    private String keyStoreType = "JKS";
    private String keyStorePath;
    private String keyStorePassword;
    private String trustStoreProvider = TransportConstants.DEFAULT_TRUSTSTORE_PROVIDER;
    private String trustStoreType = "JKS";
    private String trustStorePath;
    private String trustStorePassword;

    public int getRmiRegistryPort() {
        return this.rmiRegistryPort;
    }

    public void setRmiRegistryPort(int rmiRegistryPort) {
        this.rmiRegistryPort = rmiRegistryPort;
    }

    public String getConnectorHost() {
        return this.connectorHost;
    }

    public void setConnectorHost(String connectorHost) {
        this.connectorHost = connectorHost;
    }

    public int getConnectorPort() {
        return this.connectorPort;
    }

    public void setConnectorPort(int connectorPort) {
        this.connectorPort = connectorPort;
    }

    public String getJmxRealm() {
        return this.jmxRealm;
    }

    public void setJmxRealm(String jmxRealm) {
        this.jmxRealm = jmxRealm;
    }

    public String getServiceUrl() {
        String rmiServer = "";
        if (this.rmiRegistryPort != 0) {
            rmiServer = "" + this.getConnectorHost() + ":" + this.rmiRegistryPort;
        }
        return "service:jmx:rmi://" + rmiServer + "/jndi/rmi://" + this.getConnectorHost() + ":" + this.connectorPort + this.connectorPath;
    }

    public String getAuthenticatorType() {
        return this.authenticatorType;
    }

    public void setAuthenticatorType(String authenticatorType) {
        this.authenticatorType = authenticatorType;
    }

    public boolean isSecured() {
        return this.secured;
    }

    public String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    public void setKeyStoreProvider(String keyStoreProvider) {
        this.keyStoreProvider = keyStoreProvider;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getTrustStoreProvider() {
        return this.trustStoreProvider;
    }

    public void setTrustStoreProvider(String trustStoreProvider) {
        this.trustStoreProvider = trustStoreProvider;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public void setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setSecured(Boolean secured) {
        this.secured = secured;
    }
}

