/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command.core;

import java.io.File;
import java.io.PrintStream;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.core.InternalDiffChangelogCommandStep;
import liquibase.command.core.InternalSnapshotCommandStep;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.DiffToChangeLog;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.util.StringUtil;

public class InternalGenerateChangelogCommandStep
extends InternalDiffChangelogCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"internalGenerateChangelog"};
    private static final String INFO_MESSAGE = "When generating formatted SQL changelogs, it is important to decide if batched statements\nshould be split or not.  For storedlogic objects, the default behavior is 'splitStatements:false'\n.All other objects default to 'splitStatements:true'.  See https://docs.liquibase.org for additional information.";
    public static final CommandArgumentDefinition<String> AUTHOR_ARG;
    public static final CommandArgumentDefinition<String> CONTEXT_ARG;

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setInternal(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        this.outputBestPracticeMessage();
        String changeLogFile = StringUtil.trimToNull((String)commandScope.getArgumentValue(CHANGELOG_FILE_ARG));
        if (changeLogFile != null && changeLogFile.toLowerCase().endsWith(".sql")) {
            Scope.getCurrentScope().getUI().sendMessage("\nWhen generating formatted SQL changelogs, it is important to decide if batched statements\nshould be split or not.  For storedlogic objects, the default behavior is 'splitStatements:false'\n.All other objects default to 'splitStatements:true'.  See https://docs.liquibase.org for additional information.\n");
            Scope.getCurrentScope().getLog(this.getClass()).info("\nWhen generating formatted SQL changelogs, it is important to decide if batched statements\nshould be split or not.  For storedlogic objects, the default behavior is 'splitStatements:false'\n.All other objects default to 'splitStatements:true'.  See https://docs.liquibase.org for additional information.\n");
        }
        Database referenceDatabase = (Database)commandScope.getArgumentValue(REFERENCE_DATABASE_ARG);
        InternalSnapshotCommandStep.logUnsupportedDatabase(referenceDatabase, this.getClass());
        DiffResult diffResult = this.createDiffResult(commandScope);
        DiffToChangeLog changeLogWriter = new DiffToChangeLog(diffResult, (DiffOutputControl)commandScope.getArgumentValue(DIFF_OUTPUT_CONTROL_ARG));
        changeLogWriter.setChangeSetAuthor(commandScope.getArgumentValue(AUTHOR_ARG));
        changeLogWriter.setChangeSetContext(commandScope.getArgumentValue(CONTEXT_ARG));
        changeLogWriter.setChangeSetPath(changeLogFile);
        ObjectQuotingStrategy originalStrategy = referenceDatabase.getObjectQuotingStrategy();
        try {
            referenceDatabase.setObjectQuotingStrategy(ObjectQuotingStrategy.QUOTE_ALL_OBJECTS);
            if (StringUtil.trimToNull(changeLogFile) != null) {
                changeLogWriter.print(changeLogFile);
            } else {
                PrintStream outputStream = new PrintStream(resultsBuilder.getOutputStream());
                try {
                    changeLogWriter.print(outputStream);
                }
                finally {
                    outputStream.flush();
                }
            }
            if (StringUtil.trimToNull(changeLogFile) != null) {
                Scope.getCurrentScope().getUI().sendMessage("Generated changelog written to " + new File(changeLogFile).getAbsolutePath());
            }
        }
        finally {
            referenceDatabase.setObjectQuotingStrategy(originalStrategy);
        }
    }

    @Override
    protected DatabaseSnapshot createTargetSnapshot(CommandScope commandScope) throws DatabaseException, InvalidExampleException {
        SnapshotControl snapshotControl = new SnapshotControl((Database)commandScope.getArgumentValue(REFERENCE_DATABASE_ARG), (Class[])commandScope.getArgumentValue(SNAPSHOT_TYPES_ARG));
        return SnapshotGeneratorFactory.getInstance().createSnapshot(((CompareControl)commandScope.getArgumentValue(COMPARE_CONTROL_ARG)).getSchemas(CompareControl.DatabaseRole.REFERENCE), null, snapshotControl);
    }

    static {
        CommandBuilder builder = new CommandBuilder(new String[][]{COMMAND_NAME});
        AUTHOR_ARG = builder.argument("author", String.class).build();
        CONTEXT_ARG = builder.argument("context", String.class).build();
    }
}

