/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseTableMetaData;
import org.dbunit.database.DefaultMetadataHandler;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.IMetadataHandler;
import org.dbunit.dataset.AbstractTableMetaData;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.DataTypeException;
import org.dbunit.dataset.datatype.IDataTypeFactory;
import org.dbunit.util.SQLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetTableMetaData
extends AbstractTableMetaData {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseTableMetaData.class);
    private DefaultTableMetaData wrappedTableMetaData;
    private boolean _caseSensitiveMetaData;

    public ResultSetTableMetaData(String tableName, ResultSet resultSet, IDatabaseConnection connection, boolean caseSensitiveMetaData) throws DataSetException, SQLException {
        this._caseSensitiveMetaData = caseSensitiveMetaData;
        this.wrappedTableMetaData = this.createMetaData(tableName, resultSet, connection);
    }

    public ResultSetTableMetaData(String tableName, ResultSet resultSet, IDataTypeFactory dataTypeFactory, boolean caseSensitiveMetaData) throws DataSetException, SQLException {
        this._caseSensitiveMetaData = caseSensitiveMetaData;
        this.wrappedTableMetaData = this.createMetaData(tableName, resultSet, dataTypeFactory, new DefaultMetadataHandler());
    }

    private DefaultTableMetaData createMetaData(String tableName, ResultSet resultSet, IDatabaseConnection connection) throws SQLException, DataSetException {
        if (logger.isTraceEnabled()) {
            logger.trace("createMetaData(tableName={}, resultSet={}, connection={}) - start", new Object[]{tableName, resultSet, connection});
        }
        DatabaseConfig dbConfig = connection.getConfig();
        IMetadataHandler columnFactory = (IMetadataHandler)dbConfig.getProperty("http://www.dbunit.org/properties/metadataHandler");
        IDataTypeFactory typeFactory = super.getDataTypeFactory(connection);
        return this.createMetaData(tableName, resultSet, typeFactory, columnFactory);
    }

    private DefaultTableMetaData createMetaData(String tableName, ResultSet resultSet, IDataTypeFactory dataTypeFactory, IMetadataHandler columnFactory) throws DataSetException, SQLException {
        if (logger.isTraceEnabled()) {
            logger.trace("createMetaData(tableName={}, resultSet={}, dataTypeFactory={}, columnFactory={}) - start", new Object[]{tableName, resultSet, dataTypeFactory, columnFactory});
        }
        Connection connection = resultSet.getStatement().getConnection();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSetMetaData metaData = resultSet.getMetaData();
        Column[] columns = new Column[metaData.getColumnCount()];
        int i = 0;
        while (i < columns.length) {
            int rsIndex = i + 1;
            columns[i] = this.createColumnFromDbMetaData(metaData, rsIndex, databaseMetaData, dataTypeFactory, columnFactory);
            if (columns[i] == null) {
                columns[i] = this.createColumnFromRsMetaData(metaData, rsIndex, tableName, dataTypeFactory);
            }
            ++i;
        }
        return new DefaultTableMetaData(tableName, columns);
    }

    private Column createColumnFromRsMetaData(ResultSetMetaData rsMetaData, int rsIndex, String tableName, IDataTypeFactory dataTypeFactory) throws SQLException, DataTypeException {
        if (logger.isTraceEnabled()) {
            logger.trace("createColumnFromRsMetaData(rsMetaData={}, rsIndex={}, tableName={}, dataTypeFactory={}) - start", new Object[]{rsMetaData, String.valueOf(rsIndex), tableName, dataTypeFactory});
        }
        int columnType = rsMetaData.getColumnType(rsIndex);
        String columnTypeName = rsMetaData.getColumnTypeName(rsIndex);
        String columnName = rsMetaData.getColumnLabel(rsIndex);
        int isNullable = rsMetaData.isNullable(rsIndex);
        DataType dataType = dataTypeFactory.createDataType(columnType, columnTypeName, tableName, columnName);
        Column column = new Column(columnName, dataType, columnTypeName, Column.nullableValue(isNullable));
        return column;
    }

    private Column createColumnFromDbMetaData(ResultSetMetaData rsMetaData, int rsIndex, DatabaseMetaData databaseMetaData, IDataTypeFactory dataTypeFactory, IMetadataHandler metadataHandler) throws SQLException, DataTypeException {
        if (logger.isTraceEnabled()) {
            logger.trace("createColumnFromMetaData(rsMetaData={}, rsIndex={}, databaseMetaData={}, dataTypeFactory={}, columnFactory={}) - start", new Object[]{rsMetaData, String.valueOf(rsIndex), databaseMetaData, dataTypeFactory, metadataHandler});
        }
        String catalogName = rsMetaData.getCatalogName(rsIndex);
        String schemaName = rsMetaData.getSchemaName(rsIndex);
        String tableName = rsMetaData.getTableName(rsIndex);
        String columnName = rsMetaData.getColumnLabel(rsIndex);
        catalogName = this.trim(catalogName);
        schemaName = this.trim(schemaName);
        tableName = this.trim(tableName);
        columnName = this.trim(columnName);
        if (catalogName != null && catalogName.equals("")) {
            catalogName = null;
        }
        if (schemaName != null && schemaName.equals("")) {
            logger.debug("The 'schemaName' from the ResultSetMetaData is empty-string and not applicable hence. Will not try to lookup column properties via DatabaseMetaData.getColumns.");
            return null;
        }
        if (tableName != null && tableName.equals("")) {
            logger.debug("The 'tableName' from the ResultSetMetaData is empty-string and not applicable hence. Will not try to lookup column properties via DatabaseMetaData.getColumns.");
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("All attributes from the ResultSetMetaData are valid, trying to lookup values in DatabaseMetaData. catalog={}, schema={}, table={}, column={}", new Object[]{catalogName, schemaName, tableName, columnName});
        }
        ResultSet columnsResultSet = metadataHandler.getColumns(databaseMetaData, schemaName, tableName);
        try {
            Column column;
            this.scrollTo(columnsResultSet, metadataHandler, catalogName, schemaName, tableName, columnName);
            Column column2 = column = SQLHelper.createColumn(columnsResultSet, dataTypeFactory, true);
            return column2;
        }
        catch (IllegalStateException e) {
            logger.warn("Cannot find column from ResultSetMetaData info via DatabaseMetaData. Returning null. Even if this is expected to never happen it probably happened due to a JDBC driver bug. To get around this you may want to configure a user defined " + IMetadataHandler.class, (Throwable)e);
            return null;
        }
        finally {
            SQLHelper.close(columnsResultSet);
        }
    }

    private String trim(String value) {
        return value == null ? null : value.trim();
    }

    private void scrollTo(ResultSet columnsResultSet, IMetadataHandler metadataHandler, String catalog, String schema, String table, String column) throws SQLException {
        while (columnsResultSet.next()) {
            boolean match = metadataHandler.matches(columnsResultSet, catalog, schema, table, column, this._caseSensitiveMetaData);
            if (!match) continue;
            return;
        }
        String msg = "Did not find column '" + column + "' for <schema.table> '" + schema + "." + table + "' in catalog '" + catalog + "' because names do not exactly match.";
        throw new IllegalStateException(msg);
    }

    @Override
    public Column[] getColumns() throws DataSetException {
        return this.wrappedTableMetaData.getColumns();
    }

    @Override
    public Column[] getPrimaryKeys() throws DataSetException {
        return this.wrappedTableMetaData.getPrimaryKeys();
    }

    @Override
    public String getTableName() {
        return this.wrappedTableMetaData.getTableName();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append("[");
        sb.append("wrappedTableMetaData=").append(this.wrappedTableMetaData);
        sb.append("]");
        return sb.toString();
    }
}

