/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.tracing;

import com.google.api.core.InternalApi;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.OpencensusTracer;
import com.google.api.gax.tracing.SpanName;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Span;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import java.util.Map;
import javax.annotation.Nonnull;

@InternalApi(value="For google-cloud-java client use only")
public final class OpencensusTracerFactory
implements ApiTracerFactory {
    @Nonnull
    private final Tracer internalTracer;
    @Nonnull
    private final Map<String, AttributeValue> spanAttributes;

    public OpencensusTracerFactory() {
        this((Map<String, String>)ImmutableMap.of());
    }

    public OpencensusTracerFactory(Map<String, String> spanAttributes) {
        this(Tracing.getTracer(), spanAttributes);
    }

    @InternalApi(value="Visible for testing")
    OpencensusTracerFactory(Tracer internalTracer, @Nonnull Map<String, String> spanAttributes) {
        this.internalTracer = (Tracer)Preconditions.checkNotNull((Object)internalTracer, (Object)"internalTracer can't be null");
        ImmutableMap.Builder formattedSpanAttributes = ImmutableMap.builder();
        for (Map.Entry<String, String> entry : spanAttributes.entrySet()) {
            formattedSpanAttributes.put((Object)entry.getKey(), (Object)AttributeValue.stringAttributeValue((String)entry.getValue()));
        }
        this.spanAttributes = formattedSpanAttributes.build();
    }

    @Override
    public ApiTracer newTracer(ApiTracer parent, SpanName spanName, ApiTracerFactory.OperationType operationType) {
        Span parentSpan = this.internalTracer.getCurrentSpan();
        if (parent instanceof OpencensusTracer) {
            parentSpan = ((OpencensusTracer)parent).getSpan();
        }
        Span span = this.internalTracer.spanBuilderWithExplicitParent(spanName.toString(), parentSpan).setRecordEvents(true).startSpan();
        span.putAttributes(this.spanAttributes);
        return new OpencensusTracer(this.internalTracer, span, operationType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpencensusTracerFactory that = (OpencensusTracerFactory)o;
        return Objects.equal((Object)this.internalTracer, (Object)that.internalTracer) && Objects.equal(this.spanAttributes, that.spanAttributes);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.internalTracer, this.spanAttributes});
    }
}

