/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.ObjectMessage;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;
import org.apache.activemq.artemis.jms.client.ConnectionFactoryOptions;
import org.apache.activemq.artemis.utils.ObjectInputStreamWithClassLoader;

public class ActiveMQObjectMessage
extends ActiveMQMessage
implements ObjectMessage {
    public static final byte TYPE = 2;
    private byte[] data;
    private final ConnectionFactoryOptions options;

    protected ActiveMQObjectMessage(ClientSession session, ConnectionFactoryOptions options) {
        super((byte)2, session);
        this.options = options;
    }

    protected ActiveMQObjectMessage(ClientMessage message, ClientSession session, ConnectionFactoryOptions options) {
        super(message, session);
        this.options = options;
    }

    public ActiveMQObjectMessage(ObjectMessage foreign, ClientSession session, ConnectionFactoryOptions options) throws JMSException {
        super((Message)foreign, (byte)2, session);
        this.setObject(foreign.getObject());
        this.options = options;
    }

    @Override
    public byte getType() {
        return 2;
    }

    @Override
    public void doBeforeSend() throws Exception {
        this.message.getBodyBuffer().clear();
        if (this.data != null) {
            this.message.getBodyBuffer().writeInt(this.data.length);
            this.message.getBodyBuffer().writeBytes(this.data);
        }
        super.doBeforeSend();
    }

    @Override
    public void doBeforeReceive() throws ActiveMQException {
        super.doBeforeReceive();
        try {
            int len = this.message.getBodyBuffer().readInt();
            this.data = new byte[len];
            this.message.getBodyBuffer().readBytes(this.data);
        }
        catch (Exception e) {
            this.data = null;
        }
    }

    public void setObject(Serializable object) throws JMSException {
        this.checkWrite();
        if (object != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(object);
                oos.flush();
                this.data = baos.toByteArray();
            }
            catch (Exception e) {
                JMSException je = new JMSException("Failed to serialize object");
                je.setLinkedException(e);
                je.initCause((Throwable)e);
                throw je;
            }
        }
    }

    public Serializable getObject() throws JMSException {
        Serializable serializable;
        if (this.data == null || this.data.length == 0) {
            return null;
        }
        ObjectInputStreamWithClassLoader ois = new ObjectInputStreamWithClassLoader((InputStream)new ByteArrayInputStream(this.data));
        try {
            Serializable object;
            String whiteList;
            String blackList = this.getDeserializationBlackList();
            if (blackList != null) {
                ois.setBlackList(blackList);
            }
            if ((whiteList = this.getDeserializationWhiteList()) != null) {
                ois.setWhiteList(whiteList);
            }
            serializable = object = (Serializable)ois.readObject();
        }
        catch (Throwable blackList) {
            try {
                try {
                    ois.close();
                }
                catch (Throwable throwable) {
                    blackList.addSuppressed(throwable);
                }
                throw blackList;
            }
            catch (Exception e) {
                JMSException je = new JMSException(e.getMessage());
                je.setStackTrace(e.getStackTrace());
                throw je;
            }
        }
        ois.close();
        return serializable;
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.data = null;
    }

    @Override
    protected <T> T getBodyInternal(Class<T> c) throws MessageFormatException {
        try {
            return (T)this.getObject();
        }
        catch (JMSException e) {
            throw new MessageFormatException("Deserialization error on ActiveMQObjectMessage");
        }
    }

    @Override
    public boolean isBodyAssignableTo(Class c) {
        if (this.data == null) {
            return true;
        }
        try {
            return Serializable.class == c || Object.class == c || c.isInstance(this.getObject());
        }
        catch (JMSException e) {
            return false;
        }
    }

    private String getDeserializationBlackList() {
        if (this.options == null) {
            return null;
        }
        return this.options.getDeserializationBlackList();
    }

    private String getDeserializationWhiteList() {
        if (this.options == null) {
            return null;
        }
        return this.options.getDeserializationWhiteList();
    }
}

