/*
 * Decompiled with CFR 0.152.
 */
package kamon.jsr166;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import kamon.jsr166.Striped64;

public class LongAdder
extends Striped64
implements Serializable {
    private static final long serialVersionUID = 7249069246863182397L;

    public void add(long l) {
        long l2;
        Striped64.Cell[] cellArray = this.cells;
        if (this.cells != null || !this.casBase(l2 = this.base, l2 + l)) {
            long l3;
            Striped64.Cell cell;
            int n;
            boolean bl = true;
            if (cellArray == null || (n = cellArray.length - 1) < 0 || (cell = cellArray[LongAdder.getProbe() & n]) == null || !(bl = cell.cas(l3 = cell.value, l3 + l))) {
                this.longAccumulate(l, null, bl);
            }
        }
    }

    public void increment() {
        this.add(1L);
    }

    public void decrement() {
        this.add(-1L);
    }

    public long sum() {
        Striped64.Cell[] cellArray = this.cells;
        long l = this.base;
        if (cellArray != null) {
            for (Striped64.Cell cell : cellArray) {
                if (cell == null) continue;
                l += cell.value;
            }
        }
        return l;
    }

    public void reset() {
        Striped64.Cell[] cellArray = this.cells;
        this.base = 0L;
        if (cellArray != null) {
            for (Striped64.Cell cell : cellArray) {
                if (cell == null) continue;
                cell.reset();
            }
        }
    }

    public long sumThenReset() {
        Striped64.Cell[] cellArray = this.cells;
        long l = this.base;
        this.base = 0L;
        if (cellArray != null) {
            for (Striped64.Cell cell : cellArray) {
                if (cell == null) continue;
                l += cell.value;
                cell.reset();
            }
        }
        return l;
    }

    public long sumAndReset() {
        long l = this.getAndSetBase(0L);
        Striped64.Cell[] cellArray = this.cells;
        if (cellArray != null) {
            for (Striped64.Cell cell : cellArray) {
                if (cell == null) continue;
                l += cell.getAndSet(0L);
            }
        }
        return l;
    }

    public String toString() {
        return Long.toString(this.sum());
    }

    @Override
    public long longValue() {
        return this.sum();
    }

    @Override
    public int intValue() {
        return (int)this.sum();
    }

    @Override
    public float floatValue() {
        return this.sum();
    }

    @Override
    public double doubleValue() {
        return this.sum();
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 7249069246863182397L;
        private final long value;

        SerializationProxy(LongAdder longAdder) {
            this.value = longAdder.sum();
        }

        private Object readResolve() {
            LongAdder longAdder = new LongAdder();
            longAdder.base = this.value;
            return longAdder;
        }
    }
}

