/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import liquibase.Scope;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandDefinition;
import liquibase.exception.CommandExecutionException;
import liquibase.resource.InputStreamList;
import liquibase.util.StringUtil;

public abstract class AbstractChecksCommandStep
extends AbstractCommandStep {
    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setHelpFooter("\nNOTES\nLiquibase Pro users can enable and customize as many rules as they want!\nLearn more about Liquibase Quality Checks at https://docs.liquibase.com/quality-checks.\nGet your FREE Pro trial today https://liquibase.com/protrial and add it to your defaults file or use in an Environment variable.");
    }

    protected static AbstractLiquibaseRule findConfigurableParentRule(AbstractConfigurableRule object, List<AbstractLiquibaseRule> list, String string, String string2) {
        if (!((Optional)(object = ((AbstractConfigurableRule)object).findParentRule(list))).isPresent()) {
            throw new CommandExecutionException(System.lineSeparator() + System.lineSeparator() + "Check '" + string + "' was copied from a rule which does not exist.  Run 'liquibase checks show' to see a list of available checks.");
        }
        if (!((AbstractLiquibaseRule)(object = (AbstractLiquibaseRule)((Optional)object).get())).isConfigurable()) {
            throw new CommandExecutionException(System.lineSeparator() + System.lineSeparator() + "Check '" + string + "' " + string2 + "." + System.lineSeparator() + "Run 'liquibase checks show' to see a list of all available checks and customization options for checks.");
        }
        return object;
    }

    public static List<AbstractLiquibaseRule> listAllRules() {
        ArrayList<AbstractLiquibaseRule> arrayList = new ArrayList<AbstractLiquibaseRule>(Scope.getCurrentScope().getServiceLocator().findInstances(AbstractLiquibaseRule.class));
        Collections.sort(arrayList);
        return arrayList;
    }

    public static AbstractLiquibaseRule findRuleByShortName(String string) {
        return AbstractChecksCommandStep.findRuleByShortName(AbstractChecksCommandStep.listAllRules(), string);
    }

    public static AbstractLiquibaseRule findRuleByShortName(List<AbstractLiquibaseRule> object, String string) {
        if (((Optional)(object = object.stream().filter(abstractLiquibaseRule -> abstractLiquibaseRule.getShortName().equalsIgnoreCase(string)).findFirst())).isPresent()) {
            return (AbstractLiquibaseRule)((Optional)object).get();
        }
        throw new CommandExecutionException("\n\nCheck '" + string + "' does not exist.  Run 'liquibase checks show' to see a list of available checks.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void checkFileArgExistence(String string, String string2) {
        if (StringUtil.isEmpty(string)) {
            return;
        }
        try {
            InputStreamList inputStreamList = Scope.getCurrentScope().getResourceAccessor().openStreams(null, string);
            Throwable throwable = null;
            try {
                if (inputStreamList == null || inputStreamList.isEmpty()) {
                    throw new IllegalArgumentException(String.format("\nWARNING: The %s file '%s' was not located. Correct this issue and try to run checks again.", string2, string));
                }
                if (inputStreamList.size() > 1) {
                    throw new IllegalArgumentException(String.format("\nFound multiple %s files named '%s'. Correct this issue and try to run checks again.", string2, string));
                }
                if (inputStreamList == null) return;
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (inputStreamList == null) throw throwable4;
                    if (throwable != null) {
                        try {
                            inputStreamList.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        throw throwable4;
                    } else {
                        inputStreamList.close();
                    }
                    throw throwable4;
                }
            }
            inputStreamList.close();
            return;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(String.format("\nError reading %s settings file '%s': %s\nCorrect this issue and try to run checks again.", string2, string, iOException.getMessage()));
        }
    }
}

