/*
 * Decompiled with CFR 0.152.
 */
package akka.pki.pem;

import akka.annotation.ApiMayChange;
import akka.pki.pem.PEMDecoder;
import akka.pki.pem.PEMLoadingException;
import java.util.Base64;
import scala.Option;
import scala.Predef$;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.util.matching.Regex;

public final class PEMDecoder$ {
    public static final PEMDecoder$ MODULE$ = new PEMDecoder$();
    private static final Regex PEMRegex;

    static {
        String labelchar = "[\\p{Print}&&[^-]]";
        String label = new StringBuilder(16).append("(?:").append(labelchar).append("(?:[\\- ]?").append(labelchar).append(")*)?").toString();
        String preeb = new StringBuilder(18).append("-----BEGIN (").append(label).append(")-----").toString();
        String posteb = new StringBuilder(14).append("-----END ").append(label).append("-----").toString();
        String laxbase64text = "[A-Za-z0-9\\+/\\s]*(?:=\\s*){0,2}";
        String laxtextualmessage = new StringBuilder(8).append("\\s*").append(preeb).append("(").append(laxbase64text).append(")").append(posteb).append("\\s*").toString();
        PEMRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(laxtextualmessage));
    }

    private Regex PEMRegex() {
        return PEMRegex;
    }

    @ApiMayChange
    public PEMDecoder.DERData decode(String pemData) throws PEMLoadingException {
        PEMDecoder.DERData dERData;
        Option option;
        String string = pemData;
        if (string != null && !(option = this.PEMRegex().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(2) == 0) {
            String label = (String)((LinearSeqOps)option.get()).apply(0);
            String base64 = (String)((LinearSeqOps)option.get()).apply(1);
            try {
                dERData = new PEMDecoder.DERData(label, Base64.getMimeDecoder().decode(base64));
            }
            catch (IllegalArgumentException iae) {
                throw new PEMLoadingException("Error decoding base64 data from PEM data (note: expected MIME-formatted Base64)", iae);
            }
        } else {
            throw new PEMLoadingException("Not a PEM encoded data.");
        }
        PEMDecoder.DERData dERData2 = dERData;
        return dERData2;
    }

    private PEMDecoder$() {
    }
}

