/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.tar;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsCharsetArchiveDriver;
import de.schlichtherle.truezip.fs.archive.tar.TarDriver;
import de.schlichtherle.truezip.fs.archive.tar.TarDriverEntry;
import de.schlichtherle.truezip.io.SequentialIOExceptionBuilder;
import de.schlichtherle.truezip.io.Streams;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.IOEntry;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.util.HashMaps;
import de.schlichtherle.truezip.util.JSE7;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarUtils;

@NotThreadSafe
public class TarInputShop
implements InputShop<TarDriverEntry> {
    private static final byte[] NULL_RECORD = new byte[512];
    private static final int CHECKSUM_OFFSET = 148;
    private final Map<String, TarDriverEntry> entries = new LinkedHashMap<String, TarDriverEntry>(HashMaps.initialCapacity((int)47));
    private final TarDriver driver;

    @CreatesObligation
    public TarInputShop(TarDriver driver, @WillNotClose InputStream in) throws EOFException, IOException {
        this.driver = driver;
        if (null == this.driver) {
            throw new NullPointerException();
        }
        try {
            this.unpack(this.newValidatedTarArchiveInputStream(in));
        }
        catch (IOException ex) {
            block5: {
                try {
                    this.close0();
                }
                catch (Throwable ex2) {
                    if (!JSE7.AVAILABLE) break block5;
                    ex.addSuppressed(ex2);
                }
            }
            throw ex;
        }
    }

    private void unpack(@WillNotClose TarArchiveInputStream tain) throws IOException {
        TarArchiveEntry tinEntry;
        TarDriver driver = this.driver;
        IOPool<?> pool = driver.getPool();
        while (null != (tinEntry = tain.getNextTarEntry())) {
            String name = TarInputShop.name(tinEntry);
            TarDriverEntry entry = this.entries.get(name);
            if (null != entry) {
                entry.release();
            }
            entry = driver.newEntry(name, tinEntry);
            if (!tinEntry.isDirectory()) {
                IOPool.Entry buffer = (IOPool.Entry)pool.allocate();
                entry.setTemp(buffer);
                try {
                    OutputStream out = buffer.getOutputSocket().newOutputStream();
                    IOException ex = null;
                    try {
                        Streams.cat((InputStream)tain, (OutputStream)out);
                    }
                    catch (IOException ex2) {
                        ex = ex2;
                        throw ex2;
                    }
                    finally {
                        block18: {
                            try {
                                out.close();
                            }
                            catch (IOException ex2) {
                                if (null == ex) {
                                    throw ex2;
                                }
                                if (!JSE7.AVAILABLE) break block18;
                                ex.addSuppressed(ex2);
                            }
                        }
                    }
                }
                catch (IOException ex) {
                    block19: {
                        try {
                            buffer.release();
                        }
                        catch (IOException ex2) {
                            if (!JSE7.AVAILABLE) break block19;
                            ex.addSuppressed(ex2);
                        }
                    }
                    throw ex;
                }
            }
            this.entries.put(name, entry);
        }
    }

    private static String name(TarArchiveEntry entry) {
        String name = entry.getName();
        Entry.Type type = entry.isDirectory() ? Entry.Type.DIRECTORY : Entry.Type.FILE;
        return FsCharsetArchiveDriver.toZipOrTarEntryName((String)name, (Entry.Type)type);
    }

    private TarArchiveInputStream newValidatedTarArchiveInputStream(InputStream in) throws EOFException, IOException {
        byte[] buf = new byte[512];
        InputStream vin = TarInputShop.readAhead(in, buf);
        if (!Arrays.equals(buf, NULL_RECORD)) {
            long expected;
            try {
                expected = TarUtils.parseOctal((byte[])buf, (int)148, (int)8);
            }
            catch (IllegalArgumentException ex) {
                throw new IOException("Invalid initial record in TAR file!", ex);
            }
            for (int i = 0; i < 8; ++i) {
                buf[148 + i] = 32;
            }
            long actual = TarUtils.computeCheckSum((byte[])buf);
            if (expected != actual) {
                throw new IOException("Invalid initial record in TAR file: Expected / actual checksum : " + expected + " / " + actual + "!");
            }
        }
        return new TarArchiveInputStream(vin, 10240, 512, this.driver.getEncoding());
    }

    static InputStream readAhead(InputStream in, byte[] buf) throws EOFException, IOException {
        if (in.markSupported()) {
            in.mark(buf.length);
            new DataInputStream(in).readFully(buf);
            in.reset();
            return in;
        }
        PushbackInputStream pin = new PushbackInputStream(in, buf.length);
        new DataInputStream(pin).readFully(buf);
        pin.unread(buf);
        return pin;
    }

    public final int getSize() {
        return this.entries.size();
    }

    public final Iterator<TarDriverEntry> iterator() {
        return Collections.unmodifiableCollection(this.entries.values()).iterator();
    }

    @CheckForNull
    public final TarDriverEntry getEntry(String name) {
        return this.entries.get(name);
    }

    public InputSocket<TarDriverEntry> getInputSocket(final String name) {
        if (null == name) {
            throw new NullPointerException();
        }
        final class Input
        extends InputSocket<TarDriverEntry> {
            Input() {
            }

            public TarDriverEntry getLocalTarget() throws IOException {
                TarDriverEntry entry = TarInputShop.this.getEntry(name);
                if (null == entry) {
                    throw new FileNotFoundException(name + " (entry not found)");
                }
                if (entry.isDirectory()) {
                    throw new FileNotFoundException(name + " (cannot read directory entries)");
                }
                return entry;
            }

            public ReadOnlyFile newReadOnlyFile() throws IOException {
                return this.getInputSocket().newReadOnlyFile();
            }

            public SeekableByteChannel newSeekableByteChannel() throws IOException {
                return this.getInputSocket().newSeekableByteChannel();
            }

            public InputStream newInputStream() throws IOException {
                return this.getInputSocket().newInputStream();
            }

            InputSocket<? extends IOEntry<?>> getInputSocket() throws IOException {
                return this.getLocalTarget().getTemp().getInputSocket();
            }
        }
        return new Input();
    }

    public void close() throws IOException {
        this.close0();
    }

    private void close0() throws IOException {
        SequentialIOExceptionBuilder builder = SequentialIOExceptionBuilder.create(IOException.class);
        Iterator<TarDriverEntry> i = this.entries.values().iterator();
        while (i.hasNext()) {
            try {
                i.next().release();
            }
            catch (IOException ex) {
                builder.warn((Exception)ex);
            }
            i.remove();
        }
        builder.check();
    }
}

