/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.grpc.Internal;
import io.grpc.xds.AutoValue_EnvoyServerProtoData_CidrRange;
import io.grpc.xds.AutoValue_EnvoyServerProtoData_FilterChain;
import io.grpc.xds.AutoValue_EnvoyServerProtoData_FilterChainMatch;
import io.grpc.xds.AutoValue_EnvoyServerProtoData_Listener;
import io.grpc.xds.HttpConnectionManager;
import io.grpc.xds.TlsContextManager;
import io.grpc.xds.internal.sds.SslContextProviderSupplier;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import javax.annotation.Nullable;

@Internal
public final class EnvoyServerProtoData {
    private EnvoyServerProtoData() {
    }

    @AutoValue
    static abstract class Listener {
        Listener() {
        }

        abstract String name();

        @Nullable
        abstract String address();

        abstract ImmutableList<FilterChain> filterChains();

        @Nullable
        abstract FilterChain defaultFilterChain();

        static Listener create(String name, @Nullable String address, ImmutableList<FilterChain> filterChains, @Nullable FilterChain defaultFilterChain) {
            return new AutoValue_EnvoyServerProtoData_Listener(name, address, filterChains, defaultFilterChain);
        }
    }

    @AutoValue
    static abstract class FilterChain {
        FilterChain() {
        }

        abstract String name();

        abstract FilterChainMatch filterChainMatch();

        abstract HttpConnectionManager httpConnectionManager();

        @Nullable
        abstract SslContextProviderSupplier sslContextProviderSupplier();

        static FilterChain create(String name, FilterChainMatch filterChainMatch, HttpConnectionManager httpConnectionManager, @Nullable DownstreamTlsContext downstreamTlsContext, TlsContextManager tlsContextManager) {
            SslContextProviderSupplier sslContextProviderSupplier = downstreamTlsContext == null ? null : new SslContextProviderSupplier(downstreamTlsContext, tlsContextManager);
            return new AutoValue_EnvoyServerProtoData_FilterChain(name, filterChainMatch, httpConnectionManager, sslContextProviderSupplier);
        }
    }

    @AutoValue
    static abstract class FilterChainMatch {
        FilterChainMatch() {
        }

        abstract int destinationPort();

        abstract ImmutableList<CidrRange> prefixRanges();

        abstract ImmutableList<String> applicationProtocols();

        abstract ImmutableList<CidrRange> sourcePrefixRanges();

        abstract ConnectionSourceType connectionSourceType();

        abstract ImmutableList<Integer> sourcePorts();

        abstract ImmutableList<String> serverNames();

        abstract String transportProtocol();

        public static FilterChainMatch create(int destinationPort, ImmutableList<CidrRange> prefixRanges, ImmutableList<String> applicationProtocols, ImmutableList<CidrRange> sourcePrefixRanges, ConnectionSourceType connectionSourceType, ImmutableList<Integer> sourcePorts, ImmutableList<String> serverNames, String transportProtocol) {
            return new AutoValue_EnvoyServerProtoData_FilterChainMatch(destinationPort, prefixRanges, applicationProtocols, sourcePrefixRanges, connectionSourceType, sourcePorts, serverNames, transportProtocol);
        }
    }

    static enum ConnectionSourceType {
        ANY,
        SAME_IP_OR_LOOPBACK,
        EXTERNAL;

    }

    @AutoValue
    static abstract class CidrRange {
        CidrRange() {
        }

        abstract InetAddress addressPrefix();

        abstract int prefixLen();

        static CidrRange create(String addressPrefix, int prefixLen) throws UnknownHostException {
            return new AutoValue_EnvoyServerProtoData_CidrRange(InetAddress.getByName(addressPrefix), prefixLen);
        }
    }

    public static final class DownstreamTlsContext
    extends BaseTlsContext {
        private final boolean requireClientCertificate;

        @VisibleForTesting
        public DownstreamTlsContext(CommonTlsContext commonTlsContext, boolean requireClientCertificate) {
            super(commonTlsContext);
            this.requireClientCertificate = requireClientCertificate;
        }

        public static DownstreamTlsContext fromEnvoyProtoDownstreamTlsContext(io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.DownstreamTlsContext downstreamTlsContext) {
            return new DownstreamTlsContext(downstreamTlsContext.getCommonTlsContext(), downstreamTlsContext.hasRequireClientCertificate());
        }

        public boolean isRequireClientCertificate() {
            return this.requireClientCertificate;
        }

        public String toString() {
            return "DownstreamTlsContext{commonTlsContext=" + this.commonTlsContext + ", requireClientCertificate=" + this.requireClientCertificate + '}';
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DownstreamTlsContext that = (DownstreamTlsContext)o;
            return this.requireClientCertificate == that.requireClientCertificate;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.requireClientCertificate);
        }
    }

    public static final class UpstreamTlsContext
    extends BaseTlsContext {
        @VisibleForTesting
        public UpstreamTlsContext(CommonTlsContext commonTlsContext) {
            super(commonTlsContext);
        }

        public static UpstreamTlsContext fromEnvoyProtoUpstreamTlsContext(io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.UpstreamTlsContext upstreamTlsContext) {
            return new UpstreamTlsContext(upstreamTlsContext.getCommonTlsContext());
        }

        public String toString() {
            return "UpstreamTlsContext{commonTlsContext=" + this.commonTlsContext + '}';
        }
    }

    public static abstract class BaseTlsContext {
        @Nullable
        protected final CommonTlsContext commonTlsContext;

        protected BaseTlsContext(@Nullable CommonTlsContext commonTlsContext) {
            this.commonTlsContext = commonTlsContext;
        }

        @Nullable
        public CommonTlsContext getCommonTlsContext() {
            return this.commonTlsContext;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BaseTlsContext)) {
                return false;
            }
            BaseTlsContext that = (BaseTlsContext)o;
            return Objects.equals(this.commonTlsContext, that.commonTlsContext);
        }

        public int hashCode() {
            return Objects.hashCode(this.commonTlsContext);
        }
    }
}

