/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.database.anonymizer;

import com.xebialabs.database.anonymizer.AnonymizerConfiguration;
import com.xebialabs.database.anonymizer.AnonymizerContants$;
import com.xebialabs.database.anonymizer.AnonymizerDatabaseSequenceFilter;
import com.xebialabs.database.anonymizer.DatabaseRepository;
import com.xebialabs.database.anonymizer.XldReplacementDataSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.dataset.xml.FlatDtdDataSet;
import org.dbunit.dataset.xml.FlatXmlWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function1;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Service
@ScalaSignature(bytes="\u0006\u000514A\u0001D\u0007\u0001-!)Q\u0004\u0001C\u0001=!I\u0011\u0005\u0001a\u0001\u0002\u0004%\tA\t\u0005\nM\u0001\u0001\r\u00111A\u0005\u0002\u001dB\u0011\"\f\u0001A\u0002\u0003\u0005\u000b\u0015B\u0012\t\u0013u\u0002\u0001\u0019!a\u0001\n\u0003q\u0004\"\u0003\"\u0001\u0001\u0004\u0005\r\u0011\"\u0001D\u0011%)\u0005\u00011A\u0001B\u0003&q\bC\u0003H\u0001\u0011\u0005\u0001\nC\u0003O\u0001\u0011%q\nC\u0004]\u0001\t\u0007I\u0011B/\t\r\u0011\u0004\u0001\u0015!\u0003_\u00055)\u0005\u0010]8siN+'O^5dK*\u0011abD\u0001\u000bC:|g._7ju\u0016\u0014(B\u0001\t\u0012\u0003!!\u0017\r^1cCN,'B\u0001\n\u0014\u0003%AXMY5bY\u0006\u00147OC\u0001\u0015\u0003\r\u0019w.\\\u0002\u0001'\t\u0001q\u0003\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0001\"\u0001\t\u0001\u000e\u00035\t!B]3q_NLGo\u001c:z+\u0005\u0019\u0003C\u0001\u0011%\u0013\t)SB\u0001\nECR\f'-Y:f%\u0016\u0004xn]5u_JL\u0018A\u0004:fa>\u001c\u0018\u000e^8ss~#S-\u001d\u000b\u0003Q-\u0002\"\u0001G\u0015\n\u0005)J\"\u0001B+oSRDq\u0001L\u0002\u0002\u0002\u0003\u00071%A\u0002yIE\n1B]3q_NLGo\u001c:zA!\u0012Aa\f\t\u0003amj\u0011!\r\u0006\u0003eM\n!\"\u00198o_R\fG/[8o\u0015\t!T'A\u0004gC\u000e$xN]=\u000b\u0005Y:\u0014!\u00022fC:\u001c(B\u0001\u001d:\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001\u001e\u0002\u0007=\u0014x-\u0003\u0002=c\tI\u0011)\u001e;po&\u0014X\rZ\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u0016\u0003}\u0002\"\u0001\t!\n\u0005\u0005k!aF!o_:LX.\u001b>fe\u000e{gNZ5hkJ\fG/[8o\u0003E\u0019wN\u001c4jOV\u0014\u0018\r^5p]~#S-\u001d\u000b\u0003Q\u0011Cq\u0001\f\u0004\u0002\u0002\u0003\u0007q(\u0001\bd_:4\u0017nZ;sCRLwN\u001c\u0011)\u0005\u001dy\u0013!B:uCJ$HC\u0001\u0015J\u0011\u0015Q\u0005\u00021\u0001L\u00035I7OU3q_J$\u0018N\\4EEB\u0011\u0001\u0004T\u0005\u0003\u001bf\u0011qAQ8pY\u0016\fg.A\u000bhKR\u0014V\r\u001d7bG\u0016lWM\u001c;ECR\f7/\u001a;\u0015\u0005A\u001b\u0006C\u0001\u0011R\u0013\t\u0011VBA\u000bYY\u0012\u0014V\r\u001d7bG\u0016lWM\u001c;ECR\f7+\u001a;\t\u000bQK\u0001\u0019A+\u0002\u0015\r|gN\\3di&|g\u000e\u0005\u0002W56\tqK\u0003\u0002\u00111*\u0011\u0011,O\u0001\u0007I\n,h.\u001b;\n\u0005m;&A\u0005#bi\u0006\u0014\u0017m]3D_:tWm\u0019;j_:\fa\u0001\\8hO\u0016\u0014X#\u00010\u0011\u0005}\u0013W\"\u00011\u000b\u0005\u0005L\u0014!B:mMRR\u0017BA2a\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0003F\u0001\u0001g!\t9'.D\u0001i\u0015\tIw'\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016L!a\u001b5\u0003\u000fM+'O^5dK\u0002")
public class ExportService {
    @Autowired
    private DatabaseRepository repository;
    @Autowired
    private AnonymizerConfiguration configuration;
    private final Logger logger = LoggerFactory.getLogger(ExportService.class);

    public DatabaseRepository repository() {
        return this.repository;
    }

    public void repository_$eq(DatabaseRepository x$1) {
        this.repository = x$1;
    }

    public AnonymizerConfiguration configuration() {
        return this.configuration;
    }

    public void configuration_$eq(AnonymizerConfiguration x$1) {
        this.configuration = x$1;
    }

    public void start(boolean isReportingDb) {
        this.logger().info("Data export has been started. Please wait....");
        try (DatabaseConnection connection = null;){
            connection = this.repository().getDatabaseConnection(isReportingDb);
            XldReplacementDataSet replacementDataSet = this.getReplacementDataset(connection);
            String fileName = isReportingDb ? AnonymizerContants$.MODULE$.DEFAULT_REPORTING_FILE_NAME() : AnonymizerContants$.MODULE$.DEFAULT_FILE_NAME();
            FlatXmlWriter datasetWriter = new FlatXmlWriter((OutputStream)new FileOutputStream(new File(fileName)));
            String dtdFileName = isReportingDb ? AnonymizerContants$.MODULE$.REPORTING_DTD_FILE_NAME() : AnonymizerContants$.MODULE$.DTD_FILE_NAME();
            datasetWriter.setDocType(dtdFileName);
            datasetWriter.write((IDataSet)replacementDataSet);
            FlatDtdDataSet.write((IDataSet)replacementDataSet, (OutputStream)new FileOutputStream(new File(dtdFileName)));
            this.logger().info(new StringBuilder(86).append("Data export has been successfully finished. You can find ").append(fileName).append(" in the server home directory").toString());
        }
    }

    private XldReplacementDataSet getReplacementDataset(DatabaseConnection connection) {
        AnonymizerDatabaseSequenceFilter filter = new AnonymizerDatabaseSequenceFilter(this.configuration(), (IDatabaseConnection)connection);
        FilteredDataSet dataset = new FilteredDataSet((ITableFilter)filter, connection.createDataSet());
        XldReplacementDataSet replacementDataSet = new XldReplacementDataSet(this.configuration(), (IDataSet)dataset);
        CollectionConverters$.MODULE$.ListHasAsScala(this.configuration().getContentToAnonymize()).asScala().foreach((Function1 & Serializable)item -> {
            replacementDataSet.addReplacementSubstring(item.getKey(), item.getValue());
            return BoxedUnit.UNIT;
        });
        return replacementDataSet;
    }

    private Logger logger() {
        return this.logger;
    }
}

