/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.config.annotation.web.server;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.session.ReactiveSessionRepository;
import org.springframework.session.Session;
import org.springframework.session.web.server.session.SpringSessionWebSessionStore;
import org.springframework.web.server.session.DefaultWebSessionManager;
import org.springframework.web.server.session.WebSessionIdResolver;
import org.springframework.web.server.session.WebSessionManager;

@Configuration(proxyBeanMethods=false)
public class SpringWebSessionConfiguration {
    @Autowired(required=false)
    private WebSessionIdResolver webSessionIdResolver;

    @Bean(value={"webSessionManager"})
    public WebSessionManager webSessionManager(ReactiveSessionRepository<? extends Session> repository) {
        SpringSessionWebSessionStore<? extends Session> sessionStore = new SpringSessionWebSessionStore<Session>(repository);
        DefaultWebSessionManager manager = new DefaultWebSessionManager();
        manager.setSessionStore(sessionStore);
        if (this.webSessionIdResolver != null) {
            manager.setSessionIdResolver(this.webSessionIdResolver);
        }
        return manager;
    }
}

