/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.basic;

import com.datical.liquibase.ext.checks.basic.AbstractNotAllowedToContainRule;
import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.change.core.DropColumnChange;
import liquibase.util.StringUtil;

public class WarnOnColumnDrops
extends AbstractNotAllowedToContainRule {
    private static final String[] NOT_MATCHES = new String[]{"drop foreign", "drop primary", "drop index", "drop key", "drop unique", "drop check", "drop constraint", "drop partition"};

    @Override
    public List<Pattern> getReservedPhrase() {
        return Arrays.asList(Pattern.compile("drop\\s*table\\s*"), Pattern.compile("drop\\s*table\\["));
    }

    @Override
    public String getFailureMessage() {
        return "Liquibase recommends that changesets which result in columns being dropped are reviewed carefully to prevent the unintentional loss of data.  Review this changeset to confirm that the referenced column is being dropped safely.";
    }

    @Override
    public SeverityEnum getSeverity() {
        return SeverityEnum.MAJOR;
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public List<String> getTags() {
        return null;
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public String getDescription() {
        return "This check warns a user when a column is being dropped so that they can ensure that dropping the column won't lead to unintentional loss of data.";
    }

    @Override
    public String getName() {
        return "Warn when 'DROP COLUMN' detected";
    }

    @Override
    public String getShortName() {
        return "ChangeDropColumnWarn";
    }

    @Override
    public int getPriority() {
        return 40;
    }

    @Override
    public List<DynamicRuleParameterEnum> getParameters() {
        return null;
    }

    @Override
    public List<Class<? extends Change>> getOtherCompatibleChangeTypes() {
        return Collections.singletonList(DropColumnChange.class);
    }

    @Override
    public boolean doCheck(AbstractSQLChange stringArray) {
        if (StringUtil.isEmpty(stringArray.getSql())) {
            return false;
        }
        String string = StringUtil.stripComments(stringArray.getSql()).toLowerCase();
        if (!string.contains("alter table") || !string.contains("drop ")) {
            return false;
        }
        if (super.doCheck((AbstractSQLChange)stringArray)) {
            return true;
        }
        stringArray = NOT_MATCHES;
        int n2 = NOT_MATCHES.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = stringArray[i2];
            if (!string.contains(string2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean doCheck(Change change) {
        return change instanceof DropColumnChange;
    }
}

