/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.resteasy;

import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Provider
public class PathInterceptor
implements ContainerRequestFilter,
ContainerResponseFilter {
    public static final ThreadLocal<String> PATH = new ThreadLocal();
    private static final Logger logger = LoggerFactory.getLogger(PathInterceptor.class);

    public static void cleanup() {
        try {
            PATH.remove();
        }
        catch (Exception e) {
            logger.error("Error cleaning up after PathInterceptor", (Throwable)e);
        }
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        PATH.set(requestContext.getUriInfo().getPath());
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        PathInterceptor.cleanup();
    }
}

