/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl.quorum;

import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.quorum.DistributedLock;
import org.apache.activemq.artemis.quorum.DistributedPrimitiveManager;
import org.apache.activemq.artemis.quorum.MutableLong;
import org.apache.activemq.artemis.quorum.UnavailableStateException;
import org.jboss.logging.Logger;

public final class ActivationSequenceStateMachine {
    private static final long CHECK_ACTIVATION_SEQUENCE_WAIT_MILLIS = 200L;
    private static final long CHECK_REPAIRED_ACTIVATION_SEQUENCE_WAIT_MILLIS = 2000L;
    private static final long LIVE_LOCK_ACQUIRE_TIMEOUT_MILLIS = 2000L;

    private ActivationSequenceStateMachine() {
    }

    /*
     * Exception decompiling
     */
    public static DistributedLock tryActivate(String nodeId, long nodeActivationSequence, DistributedPrimitiveManager distributedManager, Logger logger) throws InterruptedException, ExecutionException, TimeoutException, UnavailableStateException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [20[CASE], 16[SWITCH]], but top level block is 9[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static ValidationResult validateActivationSequence(MutableLong coordinatedNodeSequence, DistributedLock activationLock, String lockAndLongId, long nodeActivationSequence, Logger logger2) throws UnavailableStateException {
        assert (coordinatedNodeSequence.getMutableLongId().equals(lockAndLongId));
        assert (activationLock.getLockId().equals(lockAndLongId));
        long currentCoordinatedNodeSequence = coordinatedNodeSequence.get();
        if (nodeActivationSequence == currentCoordinatedNodeSequence) {
            return ValidationResult.InSync;
        }
        if (currentCoordinatedNodeSequence > 0L) {
            logger2.infof("Not a candidate for NodeID = %s activation, local activation sequence %d does not match coordinated activation sequence %d", (Object)lockAndLongId, (Object)nodeActivationSequence, (Object)currentCoordinatedNodeSequence);
            return ValidationResult.Stale;
        }
        long claimedCoordinatedNodeSequence = -currentCoordinatedNodeSequence;
        long sequenceGap = claimedCoordinatedNodeSequence - nodeActivationSequence;
        if (sequenceGap == 0L) {
            return ValidationResult.SelfRepair;
        }
        if (sequenceGap == 1L) {
            return ValidationResult.MaybeInSync;
        }
        assert (sequenceGap > 1L);
        logger2.infof("Not a candidate for NodeID = %s activation, local activation sequence %d does not match coordinated activation sequence %d", (Object)lockAndLongId, (Object)nodeActivationSequence, (Object)claimedCoordinatedNodeSequence);
        return ValidationResult.Stale;
    }

    public static boolean awaitNextCommittedActivationSequence(DistributedPrimitiveManager distributedManager, String coordinatedLockAndNodeId, long activationSequence, long timeoutMills, Logger logger2) throws ExecutionException, InterruptedException, TimeoutException, UnavailableStateException {
        long elapsedNs;
        Objects.requireNonNull(distributedManager);
        Objects.requireNonNull(logger2);
        Objects.requireNonNull(coordinatedLockAndNodeId);
        if (activationSequence < 0L) {
            throw new IllegalArgumentException("activationSequence must be >= 0, while is " + activationSequence);
        }
        if (!distributedManager.isStarted()) {
            throw new IllegalStateException("manager must be started");
        }
        MutableLong coordinatedActivationSequence = distributedManager.getMutableLong(coordinatedLockAndNodeId);
        boolean anyNext = false;
        long timeoutNs = TimeUnit.MILLISECONDS.toNanos(timeoutMills);
        long started = System.nanoTime();
        do {
            long coordinatedValue;
            if ((coordinatedValue = coordinatedActivationSequence.get()) > activationSequence) {
                logger2.infof("Detected a new activation sequence with NodeID = %s: and sequence: %d", (Object)coordinatedLockAndNodeId, (Object)coordinatedValue);
                anyNext = true;
                break;
            }
            if (coordinatedValue < 0L) {
                long claimedSequence = -coordinatedValue;
                long activationsGap = claimedSequence - activationSequence;
                if (activationsGap > 1L) {
                    logger2.infof("Detected furthers sequential server activations from sequence %d, with NodeID = %s: and claimed sequence: %d", (Object)activationSequence, (Object)coordinatedLockAndNodeId, (Object)claimedSequence);
                    anyNext = true;
                    break;
                }
                logger2.debugf("Detected claiming of activation sequence = %d for NodeID = %s", claimedSequence, (Object)coordinatedLockAndNodeId);
            }
            try {
                TimeUnit.MILLISECONDS.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while ((elapsedNs = System.nanoTime() - started) < timeoutNs);
        return anyNext;
    }

    public static void ensureSequentialAccessToNodeData(ActiveMQServer activeMQServer, DistributedPrimitiveManager distributedPrimitiveManager, Logger logger2) throws ActiveMQException, InterruptedException, UnavailableStateException, ExecutionException, TimeoutException {
        long nextActivationSequence;
        NodeManager nodeManager = activeMQServer.getNodeManager();
        String lockAndLongId = nodeManager.getNodeId().toString();
        DistributedLock liveLock = distributedPrimitiveManager.getDistributedLock(lockAndLongId);
        if (!liveLock.isHeldByCaller()) {
            String message = String.format("Server [%s], live lock for NodeID = %s, not held, activation sequence cannot be safely changed", activeMQServer, lockAndLongId);
            logger2.info((Object)message);
            throw new UnavailableStateException(message);
        }
        long nodeActivationSequence = nodeManager.readNodeActivationSequence();
        MutableLong coordinatedNodeActivationSequence = distributedPrimitiveManager.getMutableLong(lockAndLongId);
        long currentCoordinatedActivationSequence = coordinatedNodeActivationSequence.get();
        if (currentCoordinatedActivationSequence < 0L) {
            if (nodeActivationSequence != -currentCoordinatedActivationSequence) {
                String message = String.format("Server [%s], cannot assume live role for NodeID = %s, local activation sequence %d does not match current claimed coordinated sequence %d: need repair", activeMQServer, lockAndLongId, nodeActivationSequence, -currentCoordinatedActivationSequence);
                logger2.info((Object)message);
                throw new ActiveMQException(message);
            }
            nextActivationSequence = nodeActivationSequence;
        } else {
            if (nodeActivationSequence != currentCoordinatedActivationSequence) {
                String message = String.format("Server [%s], cannot assume live role for NodeID = %s, local activation sequence %d does not match current coordinated sequence %d", activeMQServer, lockAndLongId, nodeActivationSequence, currentCoordinatedActivationSequence);
                logger2.info((Object)message);
                throw new ActiveMQException(message);
            }
            nextActivationSequence = nodeActivationSequence + 1L;
        }
        if (nodeActivationSequence != nextActivationSequence) {
            if (!coordinatedNodeActivationSequence.compareAndSet(nodeActivationSequence, -nextActivationSequence)) {
                String message = String.format("Server [%s], cannot assume live role for NodeID = %s, activation sequence claim failed, local activation sequence %d no longer matches current coordinated sequence %d", activeMQServer, lockAndLongId, nodeActivationSequence, coordinatedNodeActivationSequence.get());
                logger2.infof(message, new Object[0]);
                throw new ActiveMQException(message);
            }
            try {
                nodeManager.writeNodeActivationSequence(nextActivationSequence);
            }
            catch (NodeManager.NodeManagerException fatal) {
                logger2.errorf("Server [%s] failed to set local activation sequence to: %d for NodeId =%s. Cannot continue committing coordinated activation sequence: REQUIRES ADMIN INTERVENTION", (Object)activeMQServer, (Object)nextActivationSequence, (Object)lockAndLongId);
                throw new UnavailableStateException((Throwable)fatal);
            }
            logger2.infof("Server [%s], incremented local activation sequence to: %d for NodeId = %s", (Object)activeMQServer, (Object)nextActivationSequence, (Object)lockAndLongId);
        } else {
            nodeManager.setNodeActivationSequence(nextActivationSequence);
        }
        if (!coordinatedNodeActivationSequence.compareAndSet(-nextActivationSequence, nextActivationSequence)) {
            String message = String.format("Server [%s], cannot assume live role for NodeID = %s, activation sequence commit failed, local activation sequence %d no longer matches current coordinated sequence %d", activeMQServer, lockAndLongId, nodeActivationSequence, coordinatedNodeActivationSequence.get());
            logger2.infof(message, new Object[0]);
            throw new ActiveMQException(message);
        }
        logger2.infof("Server [%s], incremented coordinated activation sequence to: %d for NodeId = %s", (Object)activeMQServer, (Object)nextActivationSequence, (Object)lockAndLongId);
    }

    private static enum ValidationResult {
        Stale,
        InSync,
        MaybeInSync,
        SelfRepair;

    }
}

