/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.protocol;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.balancing.RedirectHandler;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManager;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;

public abstract class AbstractProtocolManager<P, I extends BaseInterceptor<P>, C extends RemotingConnection, R extends RedirectHandler>
implements ProtocolManager<I, R> {
    private final Map<SimpleString, RoutingType> prefixes = new HashMap<SimpleString, RoutingType>();
    private String securityDomain;

    protected String invokeInterceptors(List<I> interceptors, P message, C connection) {
        if (interceptors != null && !interceptors.isEmpty()) {
            for (BaseInterceptor interceptor : interceptors) {
                try {
                    if (interceptor.intercept(message, connection)) continue;
                    return interceptor.getClass().getName();
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.failedToInvokeAnInterceptor(e);
                }
            }
        }
        return null;
    }

    @Override
    public void setAnycastPrefix(String anycastPrefix) {
        for (String prefix : anycastPrefix.split(",")) {
            this.prefixes.put(SimpleString.toSimpleString((String)prefix), RoutingType.ANYCAST);
        }
    }

    @Override
    public void setMulticastPrefix(String multicastPrefix) {
        for (String prefix : multicastPrefix.split(",")) {
            this.prefixes.put(SimpleString.toSimpleString((String)prefix), RoutingType.MULTICAST);
        }
    }

    @Override
    public Map<SimpleString, RoutingType> getPrefixes() {
        return this.prefixes;
    }

    @Override
    public String getSecurityDomain() {
        return this.securityDomain;
    }

    @Override
    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }
}

