/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.spi.ExpressionResultTypeAware;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.support.PredicateToExpressionAdapter;
import org.apache.camel.support.ScriptHelper;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class SimpleBuilder
implements Predicate,
Expression,
ExpressionResultTypeAware,
PropertyConfigurer {
    private final String text;
    private Class<?> resultType;
    private volatile Expression expression;
    private volatile Predicate predicate;

    public SimpleBuilder(String text) {
        this.text = text;
    }

    public static SimpleBuilder simple(String text) {
        return new SimpleBuilder(text);
    }

    public static SimpleBuilder simple(String text, Class<?> resultType) {
        SimpleBuilder answer = SimpleBuilder.simple(text);
        answer.setResultType(resultType);
        return answer;
    }

    public static SimpleBuilder simpleF(String formatText, Object ... values) {
        return SimpleBuilder.simple(String.format(formatText, values));
    }

    public static SimpleBuilder simpleF(String formatText, Class<?> resultType, Object ... values) {
        return SimpleBuilder.simple(String.format(formatText, values), resultType);
    }

    public boolean configure(CamelContext camelContext, Object target, String name, Object value, boolean ignoreCase) {
        if (target != this) {
            throw new IllegalStateException("Can only configure our own instance !");
        }
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "resulttype": 
            case "resultType": {
                this.setResultType((Class)PropertyConfigurerSupport.property((CamelContext)camelContext, Class.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public String getText() {
        return this.text;
    }

    public String getExpressionText() {
        return this.getText();
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    public SimpleBuilder resultType(Class<?> resultType) {
        this.setResultType(resultType);
        return this;
    }

    public void init(CamelContext context) {
    }

    public boolean matches(Exchange exchange) {
        if (this.predicate == null) {
            this.predicate = this.createPredicate(exchange.getContext());
        }
        return this.predicate.matches(exchange);
    }

    public <T> T evaluate(Exchange exchange, Class<T> type) {
        if (this.expression == null) {
            this.expression = this.createExpression(exchange.getContext());
        }
        return (T)this.expression.evaluate(exchange, type);
    }

    public Predicate createPredicate(final CamelContext context) {
        try {
            final Language simple = context.resolveLanguage("simple");
            final String resolve = context.resolvePropertyPlaceholders(this.text);
            if (ScriptHelper.hasExternalScript((String)resolve)) {
                return new Predicate(){

                    public boolean matches(Exchange exchange) {
                        String r = ScriptHelper.resolveOptionalExternalScript((CamelContext)context, (Exchange)exchange, (String)resolve);
                        return simple.createPredicate(r).matches(exchange);
                    }

                    public String toString() {
                        return SimpleBuilder.this.text;
                    }
                };
            }
            Predicate pred = simple.createPredicate(resolve);
            pred.init(context);
            return pred;
        }
        catch (Exception e) {
            throw CamelExecutionException.wrapCamelExecutionException(null, (Throwable)e);
        }
    }

    public Expression createExpression(final CamelContext context) {
        if (this.resultType == Boolean.class || this.resultType == Boolean.TYPE) {
            Predicate predicate = this.createPredicate(context);
            return PredicateToExpressionAdapter.toExpression((Predicate)predicate);
        }
        try {
            Expression exp;
            final Language simple = context.resolveLanguage("simple");
            final String resolve = context.resolvePropertyPlaceholders(this.text);
            if (ScriptHelper.hasExternalScript((String)resolve)) {
                exp = new Expression(){

                    public <T> T evaluate(Exchange exchange, Class<T> type) {
                        String r = ScriptHelper.resolveOptionalExternalScript((CamelContext)context, (Exchange)exchange, (String)resolve);
                        Expression exp = simple.createExpression(r);
                        return (T)exp.evaluate(exchange, type);
                    }

                    public String toString() {
                        return SimpleBuilder.this.text;
                    }
                };
            } else {
                exp = simple.createExpression(resolve);
                exp.init(context);
            }
            if (this.resultType != null) {
                exp = ExpressionBuilder.convertToExpression((Expression)exp, this.resultType);
            }
            return exp;
        }
        catch (Exception e) {
            throw CamelExecutionException.wrapCamelExecutionException(null, (Throwable)e);
        }
    }

    public String toString() {
        return "Simple: " + this.text;
    }
}

