/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.platform.sso.oidc.web;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.platform.sso.oidc.web.CustomOidcClientInitiatedLogoutSuccessHandler;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;

public class OidcLogoutSuccessHandler
extends SimpleUrlLogoutSuccessHandler {
    private final String defaultLogoutLocation;
    private final CustomOidcClientInitiatedLogoutSuccessHandler logoutSuccessHandler;

    public OidcLogoutSuccessHandler(ClientRegistrationRepository clientRegistrationRepository, String postLogoutRedirectUri, String defaultLogoutLocation) {
        this.logoutSuccessHandler = new CustomOidcClientInitiatedLogoutSuccessHandler(clientRegistrationRepository);
        if (Strings.isNotEmpty((String)postLogoutRedirectUri)) {
            this.logoutSuccessHandler.setPostLogoutRedirectUri(postLogoutRedirectUri);
        }
        this.defaultLogoutLocation = defaultLogoutLocation;
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        if (authentication instanceof OAuth2AuthenticationToken) {
            this.logoutSuccessHandler.onLogoutSuccess(request, response, authentication);
        } else {
            response.sendRedirect(this.defaultLogoutLocation);
        }
    }
}

