/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules._csv;

import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyType;
import org.python.core.Traverseproc;
import org.python.core.Visitproc;
import org.python.expose.ExposedType;
import org.python.modules._csv.PyDialect;
import org.python.modules._csv.PyWriter$PyExposer;
import org.python.modules._csv.QuoteStyle;
import org.python.modules._csv._csv;

@ExposedType(name="_csv.writer", doc="CSV writer\n\nWriter objects are responsible for generating tabular data\nin CSV format from sequence input.\n")
public class PyWriter
extends PyObject
implements Traverseproc {
    public static final String writer_doc = "CSV writer\n\nWriter objects are responsible for generating tabular data\nin CSV format from sequence input.\n";
    public static final PyType TYPE;
    public PyDialect dialect;
    private PyObject writeline;
    private StringBuffer rec;
    private int rec_len = 0;
    private int num_fields = 0;
    private boolean quoted = false;
    public static PyString __doc__writerows;
    public static PyString __doc__writerow;

    public PyWriter(PyObject writeline, PyDialect dialect) {
        this.writeline = writeline;
        this.dialect = dialect;
    }

    public void writerows(PyObject seqseq) {
        this.writer_writerows(seqseq);
    }

    final void writer_writerows(PyObject seqseq) {
        boolean result2;
        PyObject row_obj;
        PyObject row_iter = seqseq.__iter__();
        if (row_iter == null) {
            throw _csv.Error("writerows() argument must be iterable");
        }
        while ((row_obj = row_iter.__iternext__()) != null && (result2 = this.writerow(row_obj))) {
        }
    }

    public boolean writerow(PyObject seq) {
        return this.writer_writerow(seq);
    }

    final boolean writer_writerow(PyObject seq) {
        if (!seq.isSequenceType()) {
            throw _csv.Error("sequence expected");
        }
        int len = seq.__len__();
        if (len < 0) {
            return false;
        }
        this.join_reset();
        for (int i = 0; i < len; ++i) {
            boolean append_ok;
            this.quoted = false;
            PyObject field = seq.__getitem__(i);
            if (field == null) {
                return false;
            }
            switch (this.dialect.quoting) {
                case QUOTE_NONNUMERIC: {
                    try {
                        field.__float__();
                    }
                    catch (PyException ex) {
                        this.quoted = true;
                    }
                    break;
                }
                case QUOTE_ALL: {
                    this.quoted = true;
                    break;
                }
                default: {
                    this.quoted = false;
                }
            }
            if (field instanceof PyString) {
                append_ok = this.join_append(field.toString(), len == 1);
            } else if (field == Py.None) {
                append_ok = this.join_append("", len == 1);
            } else {
                PyString str = field.getClass() == PyFloat.class ? field.__repr__() : field.__str__();
                if (str == null) {
                    return false;
                }
                append_ok = this.join_append(((PyObject)str).toString(), len == 1);
            }
            if (append_ok) continue;
            return false;
        }
        if (!this.join_append_lineterminator()) {
            return false;
        }
        this.writeline.__call__(new PyString(this.rec.toString()));
        return true;
    }

    private void join_reset() {
        this.rec_len = 0;
        this.num_fields = 0;
        this.quoted = false;
        this.rec = new StringBuffer();
    }

    private boolean join_append_lineterminator() {
        this.rec.append(this.dialect.lineterminator);
        return true;
    }

    private boolean join_append(String field, boolean quote_empty) {
        int rec_len = this.join_append_data(field, quote_empty, false);
        if (rec_len < 0) {
            return false;
        }
        this.rec_len = this.join_append_data(field, quote_empty, true);
        ++this.num_fields;
        return true;
    }

    private int join_append_data(String field, boolean quote_empty, boolean copy_phase) {
        if (this.num_fields > 0) {
            this.addChar(this.dialect.delimiter, copy_phase);
        }
        if (copy_phase && this.quoted) {
            this.addChar(this.dialect.quotechar, copy_phase);
        }
        field = field + '\u0000';
        int i = 0;
        while (true) {
            char c = field.charAt(i);
            boolean want_escape = false;
            if (c == '\u0000') break;
            if (c == this.dialect.delimiter || c == this.dialect.escapechar || c == this.dialect.quotechar || this.dialect.lineterminator.indexOf(c) > -1) {
                if (this.dialect.quoting == QuoteStyle.QUOTE_NONE) {
                    want_escape = true;
                } else {
                    if (c == this.dialect.quotechar) {
                        if (this.dialect.doublequote) {
                            this.addChar(this.dialect.quotechar, copy_phase);
                        } else {
                            want_escape = true;
                        }
                    }
                    if (!want_escape) {
                        this.quoted = true;
                    }
                }
                if (want_escape) {
                    if (this.dialect.escapechar == '\u0000') {
                        throw _csv.Error("need to escape, but no escapechar set");
                    }
                    this.addChar(this.dialect.escapechar, copy_phase);
                }
            }
            this.addChar(c, copy_phase);
            ++i;
        }
        if (i == 0 && quote_empty) {
            if (this.dialect.quoting == QuoteStyle.QUOTE_NONE) {
                throw _csv.Error("single empty field record must be quoted");
            }
            this.quoted = true;
        }
        if (this.quoted) {
            if (copy_phase) {
                this.addChar(this.dialect.quotechar, copy_phase);
            } else {
                this.rec_len += 2;
            }
        }
        return this.rec_len;
    }

    private void addChar(char c, boolean copy_phase) {
        if (copy_phase) {
            this.rec.append(c);
        }
        ++this.rec_len;
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int retVal;
        if (this.dialect != null && (retVal = visit.visit(this.dialect, arg)) != 0) {
            return retVal;
        }
        return this.writeline != null ? visit.visit(this.writeline, arg) : 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && (ob == this.dialect || ob == this.writeline);
    }

    static {
        PyType.addBuilder(PyWriter.class, new PyWriter$PyExposer());
        TYPE = PyType.fromClass(PyWriter.class);
        __doc__writerows = Py.newString("writerows(sequence of sequences)\n\nConstruct and write a series of sequences to a csv file.  Non-string\nelements will be converted to string.");
        __doc__writerow = Py.newString("writerow(sequence)\n\nConstruct and write a CSV record from a sequence of fields.  Non-string\nelements will be converted to string.");
    }
}

