/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.join;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.query.Row;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.Join;
import javax.jcr.query.qom.PropertyValue;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.SameNodeJoinCondition;
import org.apache.jackrabbit.commons.query.qom.OperandEvaluator;
import org.apache.jackrabbit.core.query.lucene.join.JoinMerger;

class SameNodeJoinMerger
extends JoinMerger {
    private final String selector1;
    private final String selector2;
    private final String path;

    public SameNodeJoinMerger(Join join, Map<String, PropertyValue> columns, OperandEvaluator evaluator, QueryObjectModelFactory factory, SameNodeJoinCondition condition) throws RepositoryException {
        super(join, columns, evaluator, factory);
        this.selector1 = condition.getSelector1Name();
        this.selector2 = condition.getSelector2Name();
        this.path = condition.getSelector2Path();
    }

    @Override
    public Set<String> getLeftValues(Row row) throws RepositoryException {
        return this.getValues(this.leftSelectors, row);
    }

    @Override
    public Set<String> getRightValues(Row row) throws RepositoryException {
        return this.getValues(this.rightSelectors, row);
    }

    @Override
    public List<Constraint> getRightJoinConstraints(Collection<Row> leftRows) throws RepositoryException {
        HashSet<String> paths = new HashSet<String>();
        for (Row row : leftRows) {
            paths.addAll(this.getLeftValues(row));
        }
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        for (String path : paths) {
            if (this.rightSelectors.contains(this.selector1)) {
                constraints.add((Constraint)this.factory.sameNode(this.selector1, path));
                continue;
            }
            constraints.add((Constraint)this.factory.sameNode(this.selector2, path));
        }
        return constraints;
    }

    private Set<String> getValues(Set<String> selectors, Row row) throws RepositoryException {
        if (selectors.contains(this.selector1)) {
            Node node = row.getNode(this.selector1);
            if (node != null) {
                return Collections.singleton(node.getPath());
            }
        } else if (selectors.contains(this.selector2)) {
            Node node = row.getNode(this.selector2);
            if (node != null) {
                try {
                    String p = node.getPath();
                    if (this.path != null && !".".equals(this.path)) {
                        if (!"/".equals(p)) {
                            p = p + "/";
                        }
                        p = p + this.path;
                    }
                    return Collections.singleton(p);
                }
                catch (PathNotFoundException pathNotFoundException) {}
            }
        } else {
            throw new RepositoryException("Invalid same node join");
        }
        return Collections.emptySet();
    }
}

