/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task.archive;

import com.google.common.collect.FluentIterable;
import com.xebialabs.deployit.engine.api.execution.PhaseContainerState;
import com.xebialabs.deployit.engine.api.execution.PhaseState;
import com.xebialabs.deployit.engine.api.execution.SatelliteConnectionState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.tasker.Block;
import com.xebialabs.deployit.engine.tasker.BlockPath;
import com.xebialabs.deployit.task.archive.ArchivedAbstractBlock;
import com.xebialabs.deployit.task.archive.ArchivedPhase;
import java.util.List;
import scala.Option;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ListBuffer;

public class ArchivedPhaseContainer
extends ArchivedAbstractBlock
implements PhaseContainerState {
    public final List<ArchivedPhase> phases;

    public ArchivedPhaseContainer(List<ArchivedPhase> phases) {
        this.phases = phases;
    }

    public List<StepState> getStepList() {
        return FluentIterable.from(this.phases).transformAndConcat(ArchivedPhase::getStepList).toList();
    }

    public StepState getStep(BlockPath path) {
        int head = path.head();
        return this.phases.get(head - 1).getStep(path.tail());
    }

    public Option<Block> getBlock(BlockPath path) {
        if (path.isEmpty()) {
            return Option.apply((Object)this);
        }
        int head = path.head();
        return this.phases.get(head - 1).getBlock(path.tail());
    }

    public Seq<Tuple2<BlockPath, StepState>> getStepsWithPaths() {
        ListBuffer swp = new ListBuffer();
        for (ArchivedPhase phase : this.phases) {
            swp.append(phase.getStepsWithPaths());
        }
        return swp;
    }

    public Iterable<PhaseState> getBlocks() {
        return FluentIterable.from(this.phases).transform(input -> input).toList();
    }

    public SatelliteConnectionState satelliteState() {
        return super.getSatelliteConnectionState();
    }
}

