/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.core.Securable;
import com.xebialabs.deployit.security.JcrPermissions;
import com.xebialabs.deployit.security.PermissionLister;
import com.xebialabs.deployit.security.Role;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.springframework.beans.factory.annotation.Autowired;

public class JcrPermissionLister
implements PermissionLister {
    private final JcrTemplate jcrTemplate;
    private final RepositoryService repositoryService;

    @Autowired
    public JcrPermissionLister(JcrTemplate jcrTemplate, RepositoryService repositoryService) {
        this.jcrTemplate = jcrTemplate;
        this.repositoryService = repositoryService;
    }

    public Map<String, List<String>> listPermissions(List<Role> roles, Paging paging) {
        return this.listPermissions(roles, true);
    }

    public Map<String, List<String>> listPermissions(Role role, Paging paging) {
        return this.listPermissions(Collections.singletonList(role), true);
    }

    public Map<String, List<String>> listGlobalPermissions(List<Role> roles, Paging paging) {
        return this.listPermissions(roles, false);
    }

    private Map<String, List<String>> listPermissions(List<Role> roles, boolean readCiLevelPermissions) {
        HashMap<String, List<String>> permissions = new HashMap<String, List<String>>();
        this.jcrTemplate.execute(session -> {
            JcrPermissionLister.readGlobalPermissions(session, permissions, roles);
            if (readCiLevelPermissions) {
                this.readCiLevelPermissions(session, permissions, roles);
            }
            return null;
        });
        return permissions;
    }

    private void readCiLevelPermissions(Session session, Map<String, List<String>> permissionList, List<Role> roles) throws RepositoryException {
        List cisWithPermissions = this.repositoryService.list(new SearchParameters().setType(Type.valueOf(Securable.class)));
        for (ConfigurationItemData ci : cisWithPermissions) {
            Node s = JcrPermissions.readSecurable(ci.getId(), session);
            JcrPermissionLister.readPermissionsFromNode(permissionList, roles, ci.getId(), s);
        }
    }

    private static void readPermissionsFromNode(Map<String, List<String>> permissionList, List<? extends Role> roles, String ci, Node s) throws RepositoryException {
        Map<String, String> permissions = JcrPermissions.readPermissionMap(s);
        Stream<String> ps = permissions.entrySet().stream().filter(e -> JcrPermissionLister.checkAllowed((String)e.getValue(), roles)).map(Map.Entry::getKey);
        permissionList.computeIfAbsent(ci, id -> new ArrayList()).addAll(ps.collect(Collectors.toList()));
    }

    private static void readGlobalPermissions(Session session, Map<String, List<String>> permissionList, List<Role> roles) throws RepositoryException {
        Node securityNode = session.getNode("/$configuration/security");
        JcrPermissionLister.readPermissionsFromNode(permissionList, roles, "global", securityNode);
    }

    private static boolean checkAllowed(String allowedRoles, List<? extends Role> principals) {
        List<String> principalRoles = JcrPermissions.rolesToIds(principals);
        return JcrPermissions.splitIds(allowedRoles).stream().anyMatch(principalRoles::contains);
    }
}

