/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.gc;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Workspace;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.apache.jackrabbit.api.management.DataStoreGarbageCollector;
import org.apache.jackrabbit.api.management.MarkEventListener;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.observation.SynchronousEventListener;
import org.apache.jackrabbit.core.persistence.IterablePersistenceManager;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.persistence.util.NodeInfo;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GarbageCollector
implements DataStoreGarbageCollector {
    static final Logger LOG = LoggerFactory.getLogger(GarbageCollector.class);
    private static final int NODESATONCE = Integer.getInteger("org.apache.jackrabbit.garbagecollector.nodesatonce", 8192);
    private static final boolean NODE_ID_SCAN = Boolean.getBoolean("org.apache.jackrabbit.garbagecollector.node_id.scan");
    private MarkEventListener callback;
    private long sleepBetweenNodes;
    private long minSplitSize = 100000L;
    private int concurrentThreadSize = 3;
    protected int testDelay;
    private final DataStore store;
    private long startScanTimestamp;
    private final ArrayList<Listener> listeners = new ArrayList();
    private final IterablePersistenceManager[] pmList;
    private final SessionImpl[] sessionList;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final RepositoryContext context;
    private boolean persistenceManagerScan;
    private volatile RepositoryException observationException;

    public GarbageCollector(RepositoryContext context, DataStore dataStore, IterablePersistenceManager[] list, SessionImpl[] sessionList) {
        this.context = context;
        this.store = dataStore;
        this.pmList = list;
        this.persistenceManagerScan = list != null;
        this.sessionList = sessionList;
    }

    public void setSleepBetweenNodes(long millis) {
        this.sleepBetweenNodes = millis;
    }

    public long getSleepBetweenNodes() {
        return this.sleepBetweenNodes;
    }

    public long getMinSplitSize() {
        return this.minSplitSize;
    }

    public void setMinSplitSize(long minSplitSize) {
        this.minSplitSize = minSplitSize;
    }

    public int getConcurrentThreadSize() {
        return this.concurrentThreadSize;
    }

    public void setConcurrentThreadSize(int concurrentThreadSize) {
        this.concurrentThreadSize = concurrentThreadSize;
    }

    public void setTestDelay(int testDelay) {
        this.testDelay = testDelay;
    }

    public void setMarkEventListener(MarkEventListener callback) {
        this.callback = callback;
    }

    public void mark() throws RepositoryException {
        if (this.store == null) {
            throw new RepositoryException("No DataStore configured.");
        }
        long now = System.currentTimeMillis();
        if (this.startScanTimestamp == 0L) {
            this.startScanTimestamp = now;
            this.store.updateModifiedDateOnAccess(this.startScanTimestamp);
        }
        if (this.pmList == null || !this.persistenceManagerScan) {
            for (SessionImpl s : this.sessionList) {
                this.scanNodes(s);
            }
        } else {
            try {
                if (!NODE_ID_SCAN) {
                    this.scanPersistenceManagersByNodeInfos();
                }
                this.scanPersistenceManagersByNodeIds();
            }
            catch (ItemStateException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
    }

    private void scanNodes(SessionImpl session) throws RepositoryException {
        Session clonedSession = session.createSession(session.getWorkspace().getName());
        this.listeners.add(new Listener(this, clonedSession));
        this.recurse(session.getRootNode(), this.sleepBetweenNodes);
    }

    public void setPersistenceManagerScan(boolean allow) {
        this.persistenceManagerScan = allow;
    }

    public boolean isPersistenceManagerScan() {
        return this.persistenceManagerScan;
    }

    private void scanPersistenceManagersByNodeInfos() throws RepositoryException, ItemStateException {
        int pmCount = 0;
        for (IterablePersistenceManager pm : this.pmList) {
            ++pmCount;
            int count = 0;
            Map<NodeId, NodeInfo> batch = pm.getAllNodeInfos(null, NODESATONCE);
            while (!batch.isEmpty()) {
                NodeId lastId = null;
                for (NodeInfo info : batch.values()) {
                    if (++count % 1000 == 0) {
                        LOG.debug(pm.toString() + " (" + pmCount + "/" + this.pmList.length + "): analyzed " + count + " nodes...");
                    }
                    lastId = info.getId();
                    if (this.callback != null) {
                        this.callback.beforeScanning(null);
                    }
                    if (!info.hasBlobsInDataStore()) continue;
                    try {
                        NodeState state = pm.load(info.getId());
                        Set<Name> propertyNames = state.getPropertyNames();
                        for (Name name : propertyNames) {
                            PropertyId pid = new PropertyId(info.getId(), name);
                            PropertyState ps = pm.load(pid);
                            if (ps.getType() != 2) continue;
                            for (InternalValue v : ps.getValues()) {
                                v.getLength();
                            }
                        }
                    }
                    catch (NoSuchItemStateException noSuchItemStateException) {
                    }
                }
                batch = pm.getAllNodeInfos(lastId, NODESATONCE);
            }
        }
        NodeInfo.clearPool();
    }

    private void scanPersistenceManagersByNodeIds() throws RepositoryException, ItemStateException {
        int pmCount = 0;
        for (IterablePersistenceManager pm : this.pmList) {
            ++pmCount;
            List<NodeId> allNodeIds = pm.getAllNodeIds(null, 0);
            int overAllCount = allNodeIds.size();
            if ((long)overAllCount > this.minSplitSize) {
                int splits = this.getConcurrentThreadSize();
                ExecutorService executorService = Executors.newFixedThreadPool(splits);
                try {
                    HashSet<Future<Void>> futures = new HashSet<Future<Void>>();
                    List<List<NodeId>> lists = this.splitIntoParts(allNodeIds, splits);
                    LOG.debug(splits + " concurrent Threads will be started. Split Size: " + lists.get(0).size() + " Total Size: " + overAllCount);
                    for (int i = 0; i < splits; ++i) {
                        List<NodeId> list = lists.get(i);
                        futures.add(executorService.submit(new ScanNodeIdListTask(i + 1, list, pm, pmCount)));
                    }
                    for (Future future : futures) {
                        future.get();
                    }
                    continue;
                }
                catch (Exception e) {
                    throw new RepositoryException((Throwable)e);
                }
                finally {
                    executorService.shutdown();
                }
            }
            this.scanNodeIdList(0, allNodeIds, pm, pmCount);
        }
    }

    private void scanNodeIdList(int split, List<NodeId> nodeList, PersistenceManager pm, int pmCount) throws RepositoryException, ItemStateException {
        int count = 0;
        for (NodeId id : nodeList) {
            if (++count % 1000 == 0) {
                if (split > 0) {
                    LOG.debug("[Split " + split + "] " + pm.toString() + " (" + pmCount + "/" + this.pmList.length + "): analyzed " + count + " nodes [" + nodeList.size() + "]...");
                } else {
                    LOG.debug(pm.toString() + " (" + pmCount + "/" + this.pmList.length + "): analyzed " + count + " nodes [" + nodeList.size() + "]...");
                }
            }
            if (this.callback != null) {
                this.callback.beforeScanning(null);
            }
            try {
                NodeState state = pm.load(id);
                Set<Name> propertyNames = state.getPropertyNames();
                for (Name name : propertyNames) {
                    PropertyId pid = new PropertyId(id, name);
                    PropertyState ps = pm.load(pid);
                    if (ps.getType() != 2) continue;
                    for (InternalValue v : ps.getValues()) {
                        v.getLength();
                    }
                }
            }
            catch (NoSuchItemStateException noSuchItemStateException) {
            }
        }
    }

    private <T> List<List<T>> splitIntoParts(List<T> ls, int parts) {
        ArrayList<List<T>> listParts = new ArrayList<List<T>>();
        int chunkSize = ls.size() / parts;
        int leftOver = ls.size() % parts;
        int iTake = chunkSize;
        int iT = ls.size();
        for (int i = 0; i < iT; i += iTake) {
            if (leftOver > 0) {
                --leftOver;
                iTake = chunkSize + 1;
            } else {
                iTake = chunkSize;
            }
            listParts.add(new ArrayList<T>(ls.subList(i, Math.min(iT, i + iTake))));
        }
        return listParts;
    }

    public void stopScan() throws RepositoryException {
        this.store.updateModifiedDateOnAccess(0L);
        if (this.listeners.size() > 0) {
            for (Listener listener : this.listeners) {
                listener.stop();
            }
            this.listeners.clear();
        }
        this.checkObservationException();
        this.context.setGcRunning(false);
    }

    public int sweep() throws RepositoryException {
        if (this.startScanTimestamp == 0L) {
            throw new RepositoryException("scan must be called first");
        }
        this.stopScan();
        return this.store.deleteAllOlderThan(this.startScanTimestamp);
    }

    public DataStore getDataStore() {
        return this.store;
    }

    void recurse(Node n, long sleep) throws RepositoryException {
        PropertyIterator it;
        if (sleep > 0L) {
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.callback != null) {
            this.callback.beforeScanning(n);
        }
        try {
            it = n.getProperties();
            while (it.hasNext()) {
                Property p = it.nextProperty();
                try {
                    if (p.getType() != 2) continue;
                    if (n.hasProperty("jcr:uuid")) {
                        this.rememberNode(n.getProperty("jcr:uuid").getString());
                    } else {
                        this.rememberNode(n.getPath());
                    }
                    if (p.isMultiple()) {
                        GarbageCollector.checkLengths(p.getLengths());
                        continue;
                    }
                    GarbageCollector.checkLengths(p.getLength());
                }
                catch (InvalidItemStateException e) {
                    LOG.debug("Property removed concurrently - ignoring", (Throwable)e);
                }
            }
        }
        catch (InvalidItemStateException e) {
            LOG.debug("Node removed concurrently - ignoring", (Throwable)e);
        }
        try {
            it = n.getNodes();
            while (it.hasNext()) {
                this.recurse(it.nextNode(), sleep);
            }
        }
        catch (InvalidItemStateException e) {
            LOG.debug("Node removed concurrently - ignoring", (Throwable)e);
        }
        this.checkObservationException();
    }

    private void rememberNode(String path) {
    }

    private static void checkLengths(long ... lengths) throws RepositoryException {
        for (long length : lengths) {
            if (length != -1L) continue;
            throw new RepositoryException("mark failed to access a property");
        }
    }

    public void close() {
        if (!this.closed.getAndSet(true)) {
            try {
                this.stopScan();
            }
            catch (RepositoryException e) {
                LOG.warn("An error occured when stopping the event listener", (Throwable)e);
            }
            for (SessionImpl s : this.sessionList) {
                s.logout();
            }
        }
    }

    private void checkObservationException() throws RepositoryException {
        RepositoryException e = this.observationException;
        if (e != null) {
            this.observationException = null;
            String message = "Exception while processing concurrent events";
            LOG.warn(message, (Throwable)e);
            e = new RepositoryException(message, (Throwable)e);
        }
    }

    void onObservationException(Exception e) {
        this.observationException = e instanceof RepositoryException ? (RepositoryException)((Object)e) : new RepositoryException((Throwable)e);
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    class Listener
    implements SynchronousEventListener {
        private final GarbageCollector gc;
        private final Session session;
        private final ObservationManager manager;

        Listener(GarbageCollector gc, Session session) throws UnsupportedRepositoryOperationException, RepositoryException {
            this.gc = gc;
            this.session = session;
            Workspace ws = session.getWorkspace();
            this.manager = ws.getObservationManager();
            this.manager.addEventListener((EventListener)this, 32, "/", true, null, null, false);
        }

        void stop() throws RepositoryException {
            this.manager.removeEventListener((EventListener)this);
            this.session.logout();
        }

        public void onEvent(EventIterator events) {
            if (GarbageCollector.this.testDelay > 0) {
                try {
                    Thread.sleep(GarbageCollector.this.testDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            while (events.hasNext()) {
                Event event = events.nextEvent();
                try {
                    String path = event.getPath();
                    try {
                        Item item = this.session.getItem(path);
                        if (!item.isNode()) continue;
                        Node n = (Node)item;
                        GarbageCollector.this.recurse(n, GarbageCollector.this.testDelay);
                    }
                    catch (PathNotFoundException item) {
                    }
                }
                catch (Exception e) {
                    this.gc.onObservationException(e);
                    try {
                        this.stop();
                    }
                    catch (RepositoryException e2) {
                        LOG.warn("Exception removing the observation listener - ignored", (Throwable)e2);
                    }
                }
            }
        }
    }

    private class ScanNodeIdListTask
    implements Callable<Void> {
        private int split;
        private List<NodeId> nodeList;
        private PersistenceManager pm;
        private int pmCount;

        public ScanNodeIdListTask(int split, List<NodeId> nodeList, PersistenceManager pm, int pmCount) {
            this.split = split;
            this.nodeList = nodeList;
            this.pm = pm;
            this.pmCount = pmCount;
        }

        @Override
        public Void call() throws Exception {
            GarbageCollector.this.scanNodeIdList(this.split, this.nodeList, this.pm, this.pmCount);
            return null;
        }
    }
}

