/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.util.ObjectHelper;

public final class ReferenceCount {
    private final AtomicLong count = new AtomicLong(0L);
    private final Runnable onFirst;
    private final Runnable onRelease;

    private ReferenceCount(Runnable onFirst, Runnable onRelease) {
        this.onFirst = ObjectHelper.notNull(onFirst, "onFirst");
        this.onRelease = ObjectHelper.notNull(onRelease, "onRelease");
    }

    public long get() {
        return this.count.get();
    }

    public void retain() throws IllegalStateException {
        block1: {
            long v;
            do {
                if ((v = this.count.get()) >= 0L) continue;
                throw new IllegalStateException("Released");
            } while (!this.count.compareAndSet(v, v + 1L));
            if (v != 0L) break block1;
            this.onFirst.run();
        }
    }

    public void release() throws IllegalStateException {
        block1: {
            long v;
            do {
                if ((v = this.count.get()) > 0L) continue;
                throw new IllegalStateException("ReferenceCount already released");
            } while (!this.count.compareAndSet(v, v - 1L));
            if (v != 1L) break block1;
            this.onRelease.run();
        }
    }

    public static ReferenceCount on(Runnable onFirst, Runnable onRelease) {
        return new ReferenceCount(onFirst, onRelease);
    }

    public static ReferenceCount onRelease(Runnable onRelease) {
        return new ReferenceCount(() -> {}, onRelease);
    }
}

