/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.http.HandlerMappingIntrospectorFactoryBean;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.CorsFilter;
import org.w3c.dom.Element;

public class CorsBeanDefinitionParser {
    private static final String HANDLER_MAPPING_INTROSPECTOR = "org.springframework.web.servlet.handler.HandlerMappingIntrospector";
    private static final String ATT_SOURCE = "configuration-source-ref";
    private static final String ATT_REF = "ref";

    public BeanMetadataElement parse(Element element, ParserContext parserContext) {
        if (element == null) {
            return null;
        }
        String filterRef = element.getAttribute(ATT_REF);
        if (StringUtils.hasText((String)filterRef)) {
            return new RuntimeBeanReference(filterRef);
        }
        BeanMetadataElement configurationSource = this.getSource(element, parserContext);
        if (configurationSource == null) {
            throw new BeanCreationException("Could not create CorsFilter");
        }
        BeanDefinitionBuilder filterBldr = BeanDefinitionBuilder.rootBeanDefinition(CorsFilter.class);
        filterBldr.addConstructorArgValue((Object)configurationSource);
        return filterBldr.getBeanDefinition();
    }

    public BeanMetadataElement getSource(Element element, ParserContext parserContext) {
        String configurationSourceRef = element.getAttribute(ATT_SOURCE);
        if (StringUtils.hasText((String)configurationSourceRef)) {
            return new RuntimeBeanReference(configurationSourceRef);
        }
        boolean mvcPresent = ClassUtils.isPresent((String)HANDLER_MAPPING_INTROSPECTOR, (ClassLoader)this.getClass().getClassLoader());
        if (!mvcPresent) {
            return null;
        }
        return new RootBeanDefinition(HandlerMappingIntrospectorFactoryBean.class);
    }
}

