/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.hits;

import java.io.IOException;
import org.apache.jackrabbit.core.query.lucene.hits.Hits;

public class HitsIntersection
implements Hits {
    private final Hits hits1;
    private final Hits hits2;
    private int nextChildrenHit = -1;
    private int nextNameTestHit = -1;

    public HitsIntersection(Hits hits1, Hits hits2) {
        this.hits1 = hits1;
        this.hits2 = hits2;
    }

    @Override
    public void set(int doc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int next() throws IOException {
        do {
            if (this.nextChildrenHit == this.nextNameTestHit) {
                this.nextNameTestHit = this.hits2.next();
                this.nextChildrenHit = this.hits1.next();
                continue;
            }
            if (this.nextNameTestHit < this.nextChildrenHit) {
                this.nextNameTestHit = this.hits2.skipTo(this.nextChildrenHit);
                continue;
            }
            this.nextChildrenHit = this.hits1.skipTo(this.nextNameTestHit);
        } while (this.nextChildrenHit > -1 && this.nextNameTestHit > -1 && this.nextNameTestHit != this.nextChildrenHit);
        int nextDoc = -1;
        if (this.nextChildrenHit == this.nextNameTestHit) {
            nextDoc = this.nextChildrenHit;
        }
        return nextDoc;
    }

    @Override
    public int skipTo(int target) throws IOException {
        this.nextChildrenHit = this.hits1.skipTo(target);
        this.nextNameTestHit = this.hits2.skipTo(target);
        if (this.nextChildrenHit == this.nextNameTestHit) {
            return this.nextChildrenHit;
        }
        return this.next();
    }
}

