/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.util;

import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;

public class TableFormatter {
    public String format(ITable table) throws DataSetException {
        StringBuffer sb = new StringBuffer();
        ITableMetaData tableMetaData = table.getTableMetaData();
        sb.append("******");
        sb.append(" table: ").append(tableMetaData.getTableName()).append(" ");
        sb.append("**");
        sb.append(" row count: ").append(table.getRowCount()).append(" ");
        sb.append("******");
        sb.append("\n");
        int width = 20;
        Column[] cols = tableMetaData.getColumns();
        int i = 0;
        while (i < cols.length) {
            sb.append(TableFormatter.padRight(cols[i].getColumnName(), width, ' '));
            sb.append("|");
            ++i;
        }
        sb.append("\n");
        i = 0;
        while (i < cols.length) {
            sb.append(TableFormatter.padRight("", width, '='));
            sb.append("|");
            ++i;
        }
        sb.append("\n");
        i = 0;
        while (i < table.getRowCount()) {
            int j = 0;
            while (j < cols.length) {
                Object value = table.getValue(i, cols[j].getColumnName());
                String stringValue = String.valueOf(value);
                sb.append(TableFormatter.padRight(stringValue, 20, ' '));
                sb.append("|");
                ++j;
            }
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    public static final String padLeft(String s, int length, char padChar) {
        String result = s;
        char[] padCharArray = TableFormatter.getPadCharArray(s, length, padChar);
        if (padCharArray != null) {
            result = TableFormatter.pad(s, padCharArray, true);
        }
        return result;
    }

    public static final String padRight(String s, int length, char padChar) {
        String result = s;
        char[] padCharArray = TableFormatter.getPadCharArray(s, length, padChar);
        if (padCharArray != null) {
            result = TableFormatter.pad(s, padCharArray, false);
        }
        return result;
    }

    private static final char[] getPadCharArray(String s, int length, char padChar) {
        if (length > 0 && length > s.length()) {
            int padCount = length - s.length();
            char[] padArray = new char[padCount];
            int i = 0;
            while (i < padArray.length) {
                padArray[i] = padChar;
                ++i;
            }
            return padArray;
        }
        return null;
    }

    private static final String pad(String s, char[] padArray, boolean padLeft) {
        StringBuffer sb = new StringBuffer(s);
        if (padLeft) {
            sb.insert(0, padArray);
        } else {
            sb.append(padArray);
        }
        return sb.toString();
    }
}

