/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.filter;

import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.filter.AbstractTableFilter;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.dataset.filter.PatternMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcludeTableFilter
extends AbstractTableFilter
implements ITableFilter {
    private static final Logger logger = LoggerFactory.getLogger(ExcludeTableFilter.class);
    private final PatternMatcher _patternMatcher = new PatternMatcher();

    public ExcludeTableFilter() {
    }

    public ExcludeTableFilter(String[] tableNames) {
        int i = 0;
        while (i < tableNames.length) {
            String tableName = tableNames[i];
            this.excludeTable(tableName);
            ++i;
        }
    }

    public void excludeTable(String patternName) {
        logger.debug("excludeTable(patternName=" + patternName + ") - start");
        this._patternMatcher.addPattern(patternName);
    }

    public boolean isEmpty() {
        logger.debug("isEmpty() - start");
        return this._patternMatcher.isEmpty();
    }

    @Override
    public boolean isValidName(String tableName) throws DataSetException {
        logger.debug("isValidName(tableName=" + tableName + ") - start");
        return !this._patternMatcher.accept(tableName);
    }
}

