/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.csv;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.csv.CsvParserException;
import org.dbunit.dataset.csv.CsvParserImpl;
import org.dbunit.dataset.csv.CsvProducer;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.stream.DefaultConsumer;
import org.dbunit.dataset.stream.IDataSetConsumer;
import org.dbunit.dataset.stream.IDataSetProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvURLProducer
implements IDataSetProducer {
    private static final Logger logger = LoggerFactory.getLogger(CsvURLProducer.class);
    private static final IDataSetConsumer EMPTY_CONSUMER = new DefaultConsumer();
    private IDataSetConsumer _consumer = EMPTY_CONSUMER;
    private URL base;
    private String tableList;

    public CsvURLProducer(URL base, String tableList) {
        this.base = base;
        this.tableList = tableList;
    }

    @Override
    public void setConsumer(IDataSetConsumer consumer) throws DataSetException {
        logger.debug("setConsumer(consumer) - start");
        this._consumer = consumer;
    }

    @Override
    public void produce() throws DataSetException {
        logger.debug("produce() - start");
        this._consumer.startDataSet();
        try {
            List tableSpecs = CsvProducer.getTables(this.base, this.tableList);
            for (String table : tableSpecs) {
                try {
                    this.produceFromURL(new URL(this.base, String.valueOf(table) + ".csv"));
                }
                catch (CsvParserException e) {
                    throw new DataSetException("error producing dataset for table '" + table + "'", e);
                }
            }
            this._consumer.endDataSet();
        }
        catch (IOException e) {
            throw new DataSetException("error getting list of tables", e);
        }
    }

    private void produceFromURL(URL url) throws DataSetException {
        logger.debug("produceFromURL(url=" + url + ") - start");
        try {
            CsvParserImpl parser = new CsvParserImpl();
            List readData = parser.parse(url);
            List readColumns = (List)readData.get(0);
            Column[] columns = new Column[readColumns.size()];
            int i = 0;
            while (i < readColumns.size()) {
                columns[i] = new Column((String)readColumns.get(i), DataType.UNKNOWN);
                ++i;
            }
            String tableName = url.getFile();
            tableName = tableName.substring(tableName.lastIndexOf("/") + 1, tableName.indexOf(".csv"));
            DefaultTableMetaData metaData = new DefaultTableMetaData(tableName, columns);
            this._consumer.startTable(metaData);
            int i2 = 1;
            while (i2 < readData.size()) {
                List rowList = (List)readData.get(i2);
                Object[] row = rowList.toArray();
                int col = 0;
                while (col < row.length) {
                    if ("null".equals(row[col])) {
                        row[col] = null;
                    }
                    ++col;
                }
                this._consumer.row(row);
                ++i2;
            }
            this._consumer.endTable();
        }
        catch (CsvParserException e) {
            throw new DataSetException("error parsing CSV for URL: '" + url + "'", e);
        }
        catch (IOException e) {
            throw new DataSetException("I/O error parsing CSV for URL: '" + url + "'", e);
        }
    }
}

