/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database.search;

import java.sql.SQLException;
import java.util.Set;
import org.apache.commons.collections.set.ListOrderedSet;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.PrimaryKeyFilter;
import org.dbunit.database.search.ExportedKeysSearchCallback;
import org.dbunit.database.search.ImportedAndExportedKeysSearchCallback;
import org.dbunit.database.search.ImportedAndExportedKeysSearchCallbackFilteredByPKs;
import org.dbunit.database.search.ImportedKeysSearchCallback;
import org.dbunit.database.search.ImportedKeysSearchCallbackFilteredByPKs;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.util.CollectionsHelper;
import org.dbunit.util.search.DepthFirstSearch;
import org.dbunit.util.search.ISearchCallback;
import org.dbunit.util.search.SearchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TablesDependencyHelper {
    private static final Logger logger = LoggerFactory.getLogger(TablesDependencyHelper.class);

    private TablesDependencyHelper() {
    }

    public static String[] getDependentTables(IDatabaseConnection connection, String rootTable) throws SearchException {
        logger.debug("getDependentTables(connection={}, rootTable={}) - start", (Object)connection, (Object)rootTable);
        return TablesDependencyHelper.getDependentTables(connection, new String[]{rootTable});
    }

    public static String[] getDependentTables(IDatabaseConnection connection, String[] rootTables) throws SearchException {
        logger.debug("getDependentTables(connection={}, rootTables={}) - start", (Object)connection, (Object)rootTables);
        ImportedKeysSearchCallback callback = new ImportedKeysSearchCallback(connection);
        DepthFirstSearch search = new DepthFirstSearch();
        ListOrderedSet tables = search.search(rootTables, (ISearchCallback)callback);
        return CollectionsHelper.setToStrings((Set)tables);
    }

    public static String[] getDependsOnTables(IDatabaseConnection connection, String rootTable) throws SearchException {
        logger.debug("getDependsOnTables(connection={}, rootTable={}) - start", (Object)connection, (Object)rootTable);
        ExportedKeysSearchCallback callback = new ExportedKeysSearchCallback(connection);
        DepthFirstSearch search = new DepthFirstSearch();
        ListOrderedSet tables = search.search(new String[]{rootTable}, (ISearchCallback)callback);
        return CollectionsHelper.setToStrings((Set)tables);
    }

    public static String[] getAllDependentTables(IDatabaseConnection connection, String rootTable) throws SearchException {
        logger.debug("getAllDependentTables(connection={}, rootTable={}) - start", (Object)connection, (Object)rootTable);
        return TablesDependencyHelper.getAllDependentTables(connection, new String[]{rootTable});
    }

    public static String[] getAllDependentTables(IDatabaseConnection connection, String[] rootTables) throws SearchException {
        logger.debug("getAllDependentTables(connection={}, rootTables={}) - start", (Object)connection, (Object)rootTables);
        ImportedAndExportedKeysSearchCallback callback = new ImportedAndExportedKeysSearchCallback(connection);
        DepthFirstSearch search = new DepthFirstSearch();
        ListOrderedSet tables = search.search(rootTables, (ISearchCallback)callback);
        return CollectionsHelper.setToStrings((Set)tables);
    }

    public static IDataSet getDataset(IDatabaseConnection connection, String rootTable, Set allowedIds) throws SearchException, SQLException, DataSetException {
        if (logger.isDebugEnabled()) {
            logger.debug("getDataset(connection={}, rootTable={}, allowedIds={}) - start", new Object[]{connection, rootTable, allowedIds});
        }
        PrimaryKeyFilter.PkTableMap map = new PrimaryKeyFilter.PkTableMap();
        map.addAll(rootTable, allowedIds);
        return TablesDependencyHelper.getDataset(connection, map);
    }

    public static IDataSet getDataset(IDatabaseConnection connection, PrimaryKeyFilter.PkTableMap rootTables) throws SearchException, SQLException, DataSetException {
        logger.debug("getDataset(connection={}, rootTables={}) - start", (Object)connection, (Object)rootTables);
        ImportedKeysSearchCallbackFilteredByPKs callback = new ImportedKeysSearchCallbackFilteredByPKs(connection, rootTables);
        ITableFilter filter = callback.getFilter();
        DepthFirstSearch search = new DepthFirstSearch();
        Object[] tableNames = rootTables.getTableNames();
        ListOrderedSet tmpTables = search.search(tableNames, (ISearchCallback)callback);
        String[] dependentTables = CollectionsHelper.setToStrings((Set)tmpTables);
        IDataSet tmpDataset = connection.createDataSet(dependentTables);
        FilteredDataSet dataset = new FilteredDataSet(filter, tmpDataset);
        return dataset;
    }

    public static IDataSet getAllDataset(IDatabaseConnection connection, String rootTable, Set allowedPKs) throws SearchException, SQLException, DataSetException {
        if (logger.isDebugEnabled()) {
            logger.debug("getAllDataset(connection={}, rootTable={}, allowedPKs={}) - start", new Object[]{connection, rootTable, allowedPKs});
        }
        PrimaryKeyFilter.PkTableMap map = new PrimaryKeyFilter.PkTableMap();
        map.addAll(rootTable, allowedPKs);
        return TablesDependencyHelper.getAllDataset(connection, map);
    }

    public static IDataSet getAllDataset(IDatabaseConnection connection, PrimaryKeyFilter.PkTableMap rootTables) throws SearchException, SQLException, DataSetException {
        logger.debug("getAllDataset(connection={}, rootTables={}) - start", (Object)connection, (Object)rootTables);
        ImportedAndExportedKeysSearchCallbackFilteredByPKs callback = new ImportedAndExportedKeysSearchCallbackFilteredByPKs(connection, rootTables);
        ITableFilter filter = callback.getFilter();
        DepthFirstSearch search = new DepthFirstSearch();
        Object[] tableNames = rootTables.getTableNames();
        ListOrderedSet tmpTables = search.search(tableNames, (ISearchCallback)callback);
        String[] dependentTables = CollectionsHelper.setToStrings((Set)tmpTables);
        IDataSet tmpDataset = connection.createDataSet(dependentTables);
        FilteredDataSet dataset = new FilteredDataSet(filter, tmpDataset);
        return dataset;
    }

    public static Set getDirectDependsOnTables(IDatabaseConnection connection, String tableName) throws SearchException {
        logger.debug("getDirectDependsOnTables(connection={}, tableName={}) - start", (Object)connection, (Object)tableName);
        ExportedKeysSearchCallback callback = new ExportedKeysSearchCallback(connection);
        DepthFirstSearch search = new DepthFirstSearch(1);
        ListOrderedSet tables = search.search(new String[]{tableName}, (ISearchCallback)callback);
        return tables;
    }

    public static Set getDirectDependentTables(IDatabaseConnection connection, String tableName) throws SearchException {
        logger.debug("getDirectDependentTables(connection={}, tableName={}) - start", (Object)connection, (Object)tableName);
        ImportedKeysSearchCallback callback = new ImportedKeysSearchCallback(connection);
        DepthFirstSearch search = new DepthFirstSearch(1);
        ListOrderedSet tables = search.search(new String[]{tableName}, (ISearchCallback)callback);
        return tables;
    }
}

