/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.language;

import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.language.TokenizerExpression;
import org.apache.camel.reifier.language.ExpressionReifier;
import org.apache.camel.spi.Language;
import org.apache.camel.support.ExpressionToPredicateAdapter;

public class TokenizerExpressionReifier
extends ExpressionReifier<TokenizerExpression> {
    public TokenizerExpressionReifier(CamelContext camelContext, ExpressionDefinition definition) {
        super(camelContext, (TokenizerExpression)definition);
    }

    @Override
    protected void configureLanguage(Language language) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        String token = ((TokenizerExpression)this.definition).getToken();
        if (token.startsWith("\\n")) {
            token = '\n' + token.substring(2);
        }
        props.put("token", token);
        props.put("endToken", ((TokenizerExpression)this.definition).getEndToken());
        props.put("inheritNamespaceTagName", ((TokenizerExpression)this.definition).getInheritNamespaceTagName());
        props.put("headerName", ((TokenizerExpression)this.definition).getHeaderName());
        props.put("groupDelimiter", ((TokenizerExpression)this.definition).getGroupDelimiter());
        props.put("regex", ((TokenizerExpression)this.definition).getRegex());
        props.put("xml", ((TokenizerExpression)this.definition).getXml());
        props.put("includeTokens", ((TokenizerExpression)this.definition).getIncludeTokens());
        props.put("group", ((TokenizerExpression)this.definition).getGroup());
        props.put("skipFirst", ((TokenizerExpression)this.definition).getSkipFirst());
        this.setProperties(language, props);
    }

    @Override
    public Predicate createPredicate() {
        Expression exp = this.createExpression();
        return ExpressionToPredicateAdapter.toPredicate((Expression)exp);
    }
}

