/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ExpressionSubElementDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.SetHeaderDefinition;
import org.apache.camel.model.ToDynamicDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,endpoint,routing")
@XmlRootElement(name="wireTap")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class WireTapDefinition<Type extends ProcessorDefinition<Type>>
extends ToDynamicDefinition
implements ExecutorServiceAwareDefinition<WireTapDefinition<Type>> {
    @XmlTransient
    private Processor newExchangeProcessor;
    @XmlAttribute(name="processorRef")
    private String newExchangeProcessorRef;
    @XmlElement(name="body")
    private ExpressionSubElementDefinition newExchangeExpression;
    @XmlElementRef
    private List<SetHeaderDefinition> headers = new ArrayList<SetHeaderDefinition>();
    @XmlTransient
    private ExecutorService executorService;
    @XmlAttribute
    private String executorServiceRef;
    @XmlAttribute
    @Metadata(defaultValue="true", javaType="java.lang.Boolean")
    private String copy;
    @XmlAttribute
    @Metadata(defaultValue="true", javaType="java.lang.Boolean")
    private String dynamicUri;
    @XmlAttribute
    private String onPrepareRef;
    @XmlTransient
    private Processor onPrepare;

    @Override
    public String getPattern() {
        return ExchangePattern.InOnly.name();
    }

    @Override
    public String toString() {
        return "WireTap[" + this.getUri() + "]";
    }

    @Override
    public String getShortName() {
        return "wireTap";
    }

    @Override
    public String getLabel() {
        return "wireTap[" + this.getUri() + "]";
    }

    public Type end() {
        return (Type)super.end();
    }

    @Override
    public void addOutput(ProcessorDefinition<?> output) {
        this.getParent().addOutput(output);
    }

    @Override
    public WireTapDefinition<Type> executorService(ExecutorService executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    @Override
    public WireTapDefinition<Type> executorServiceRef(String executorServiceRef) {
        this.setExecutorServiceRef(executorServiceRef);
        return this;
    }

    public WireTapDefinition<Type> copy() {
        return this.copy(true);
    }

    public WireTapDefinition<Type> copy(boolean copy) {
        return this.copy(Boolean.toString(copy));
    }

    public WireTapDefinition<Type> copy(String copy) {
        this.setCopy(copy);
        return this;
    }

    public WireTapDefinition<Type> dynamicUri(boolean dynamicUri) {
        return this.dynamicUri(Boolean.toString(dynamicUri));
    }

    public WireTapDefinition<Type> dynamicUri(String dynamicUri) {
        this.setDynamicUri(dynamicUri);
        return this;
    }

    public WireTapDefinition<Type> newExchangeBody(Expression expression) {
        this.setNewExchangeExpression(new ExpressionSubElementDefinition(expression));
        return this;
    }

    public WireTapDefinition<Type> newExchangeRef(String ref) {
        this.setNewExchangeProcessorRef(ref);
        return this;
    }

    public WireTapDefinition<Type> newExchange(Processor processor) {
        this.setNewExchangeProcessor(processor);
        return this;
    }

    public WireTapDefinition<Type> newExchangeHeader(String headerName, Expression expression) {
        this.headers.add(new SetHeaderDefinition(headerName, expression));
        return this;
    }

    public WireTapDefinition<Type> onPrepare(Processor onPrepare) {
        this.setOnPrepare(onPrepare);
        return this;
    }

    public WireTapDefinition<Type> onPrepareRef(String onPrepareRef) {
        this.setOnPrepareRef(onPrepareRef);
        return this;
    }

    @Override
    public WireTapDefinition<Type> cacheSize(int cacheSize) {
        return this.cacheSize(Integer.toString(cacheSize));
    }

    @Override
    public WireTapDefinition<Type> cacheSize(String cacheSize) {
        this.setCacheSize(cacheSize);
        return this;
    }

    public WireTapDefinition<Type> ignoreInvalidEndpoint() {
        this.setIgnoreInvalidEndpoint(Boolean.toString(true));
        return this;
    }

    @Override
    public String getUri() {
        return super.getUri();
    }

    @Override
    public void setUri(String uri) {
        super.setUri(uri);
    }

    public Processor getNewExchangeProcessor() {
        return this.newExchangeProcessor;
    }

    public void setNewExchangeProcessor(Processor processor) {
        this.newExchangeProcessor = processor;
    }

    public String getNewExchangeProcessorRef() {
        return this.newExchangeProcessorRef;
    }

    public void setNewExchangeProcessorRef(String ref) {
        this.newExchangeProcessorRef = ref;
    }

    public ExpressionSubElementDefinition getNewExchangeExpression() {
        return this.newExchangeExpression;
    }

    public void setNewExchangeExpression(ExpressionSubElementDefinition newExchangeExpression) {
        this.newExchangeExpression = newExchangeExpression;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public String getExecutorServiceRef() {
        return this.executorServiceRef;
    }

    public void setExecutorServiceRef(String executorServiceRef) {
        this.executorServiceRef = executorServiceRef;
    }

    public String getCopy() {
        return this.copy;
    }

    public void setCopy(String copy) {
        this.copy = copy;
    }

    public String getDynamicUri() {
        return this.dynamicUri;
    }

    public void setDynamicUri(String dynamicUri) {
        this.dynamicUri = dynamicUri;
    }

    public String getOnPrepareRef() {
        return this.onPrepareRef;
    }

    public void setOnPrepareRef(String onPrepareRef) {
        this.onPrepareRef = onPrepareRef;
    }

    public Processor getOnPrepare() {
        return this.onPrepare;
    }

    public void setOnPrepare(Processor onPrepare) {
        this.onPrepare = onPrepare;
    }

    public List<SetHeaderDefinition> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<SetHeaderDefinition> headers) {
        this.headers = headers;
    }
}

