/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.database.anonymizer.dataset;

import com.xebialabs.database.anonymizer.model.ValuesToAnonymize;
import java.util.List;
import java.util.Map;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ReplacementTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XldReplacementTable
extends ReplacementTable {
    private static final Logger logger = LoggerFactory.getLogger(XldReplacementTable.class);
    private final ITable table;
    private final List<ValuesToAnonymize> tableValueReplacements;

    public XldReplacementTable(ITable table, Map objectMap, Map substringMap, String startDelimiter, String endDelimiter, List<ValuesToAnonymize> tableValueReplacements) {
        super(table, objectMap, substringMap, startDelimiter, endDelimiter);
        this.table = table;
        this.tableValueReplacements = tableValueReplacements;
    }

    public Object getValue(int row, String column) throws DataSetException {
        logger.debug("getValue(row={}, columnName={}) - start", (Object)row, (Object)column);
        String tableName = this.table.getTableMetaData().getTableName();
        String[] tableWithSchema = tableName.split("\\.");
        for (ValuesToAnonymize replacement : this.tableValueReplacements) {
            if (!tableWithSchema[tableWithSchema.length - 1].equals(replacement.getTable()) || !column.equals(replacement.getColumn())) continue;
            return replacement.getValue();
        }
        return super.getValue(row, column);
    }
}

