/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.database.anonymizer.dataset;

import com.xebialabs.database.anonymizer.dataset.XldReplacementTable;
import com.xebialabs.database.anonymizer.model.ValuesToAnonymize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.ReplacementDataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XldReplacementDataSet
extends ReplacementDataSet {
    private static final Logger logger = LoggerFactory.getLogger(XldReplacementDataSet.class);
    private final IDataSet dataSet;
    private final Map<Object, Object> replacedItems = new HashMap<Object, Object>();
    private final Map<Object, Object> replacedSubstrings = new HashMap<Object, Object>();
    private final List<ValuesToAnonymize> tableValueReplacements = new ArrayList<ValuesToAnonymize>();

    public XldReplacementDataSet(IDataSet dataSet) {
        super(dataSet);
        this.dataSet = dataSet;
    }

    public ITable getTable(String tableName) throws DataSetException {
        logger.debug("getTable(tableName={}) - start", (Object)tableName);
        return this.createXldReplacementTable(this.dataSet.getTable(tableName));
    }

    public void addReplacementSubstring(String originalSubstring, String replacementSubstring) {
        logger.debug("addReplacementSubstring(originalSubstring={}, replacementSubstring={}) - start", (Object)originalSubstring, (Object)replacementSubstring);
        if (originalSubstring != null && replacementSubstring != null) {
            this.replacedSubstrings.put(originalSubstring, replacementSubstring);
        }
    }

    public void addReplacementObject(Object originalItem, Object replacementItem) {
        logger.debug("addReplacementObject(originalObject={}, replacementObject={}) - start", originalItem, replacementItem);
        this.replacedItems.put(originalItem, replacementItem);
    }

    public void addReplacementTablesInput(List<ValuesToAnonymize> tableInput) {
        this.tableValueReplacements.addAll(tableInput);
    }

    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        logger.debug("createIterator(reversed={}) - start", (Object)reversed);
        return new XldReplacementIterator(reversed ? this.dataSet.reverseIterator() : this.dataSet.iterator());
    }

    private XldReplacementTable createXldReplacementTable(ITable table) {
        logger.debug("createXldReplacementTable(table={}) - start", (Object)table);
        XldReplacementTable replacementTable = new XldReplacementTable(table, this.replacedItems, this.replacedSubstrings, null, null, this.tableValueReplacements);
        replacementTable.setStrictReplacement(true);
        return replacementTable;
    }

    private class XldReplacementIterator
    implements ITableIterator {
        private final ITableIterator iterator;

        public XldReplacementIterator(ITableIterator iterator) {
            this.iterator = iterator;
        }

        public boolean next() throws DataSetException {
            return this.iterator.next();
        }

        public ITableMetaData getTableMetaData() throws DataSetException {
            logger.debug("getTableMetaData() - start");
            return this.iterator.getTableMetaData();
        }

        public ITable getTable() throws DataSetException {
            logger.debug("getTable() - start");
            return XldReplacementDataSet.this.createXldReplacementTable(this.iterator.getTable());
        }
    }
}

