/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.websockets;

import com.xebialabs.deployit.core.events.ChangeSetEvent;
import com.xebialabs.deployit.core.websockets.WebSocketEndpoints;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.spi.event.MaintenanceStartEvent;
import com.xebialabs.deployit.engine.spi.event.MaintenanceStopEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.io.Serializable;
import java.util.Collection;
import nl.javadude.t2bus.Subscribe;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import scala.Function0;
import scala.Function1;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Controller
@ScalaSignature(bytes="\u0006\u0001\u0005]d\u0001\u0002\u0006\f\u0001aA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\u0006o\u0001!\t\u0001\u000f\u0005\u0006{\u0001!\tA\u0010\u0005\u0006+\u0002!IA\u0016\u0005\u00069\u0002!I!\u0018\u0005\u0006M\u0002!\ta\u001a\u0005\u0006g\u0002!\t\u0001\u001e\u0005\u0006u\u0002!Ia\u001f\u0005\b\u0003\u0007\u0002A\u0011BA#\u0005]9VMY*pG.,G/T3tg\u0006<Wm]*f]\u0012,'O\u0003\u0002\r\u001b\u0005Qq/\u001a2t_\u000e\\W\r^:\u000b\u00059y\u0011\u0001\u0002:fgRT!\u0001E\t\u0002\t\r|'/\u001a\u0006\u0003%M\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003)U\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003Y\t1aY8n\u0007\u0001\u0019\"\u0001A\r\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\r\u0005s\u0017PU3g\u0003=iWm]:bO\u0016$V-\u001c9mCR,\u0007CA\u0011+\u001b\u0005\u0011#BA\u0012%\u0003\u0011\u0019\u0018.\u001c9\u000b\u0005\u00152\u0013!C7fgN\fw-\u001b8h\u0015\t9\u0003&A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005I\u0013aA8sO&\u00111F\t\u0002\u0016'&l\u0007/T3tg\u0006<\u0017N\\4UK6\u0004H.\u0019;fQ\t\tQ\u0006\u0005\u0002/k5\tqF\u0003\u00021c\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005I\u001a\u0014a\u00024bGR|'/\u001f\u0006\u0003i\u0019\nQAY3b]NL!AN\u0018\u0003\u0013\u0005+Ho\\<je\u0016$\u0017A\u0002\u001fj]&$h\b\u0006\u0002:wA\u0011!\bA\u0007\u0002\u0017!)qD\u0001a\u0001A!\u00121(L\u0001\u0018g\u0016tGmQ5DQ\u0006tw-Z*fi6+7o]1hKN$\"a\u0010\"\u0011\u0005i\u0001\u0015BA!\u001c\u0005\u0011)f.\u001b;\t\u000b\r\u001b\u0001\u0019\u0001#\u0002\u000b\u00154XM\u001c;\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001d{\u0011AB3wK:$8/\u0003\u0002J\r\nq1\t[1oO\u0016\u001cV\r^#wK:$\bFA\u0002L!\ta5+D\u0001N\u0015\tqu*A\u0003ue\t,8O\u0003\u0002Q#\u0006A!.\u0019<bIV$WMC\u0001S\u0003\tqG.\u0003\u0002U\u001b\nI1+\u001e2tGJL'-Z\u0001!]>$\u0018NZ=BE>,H/T1j]R,g.\u00198dK6{G-Z\"iC:<W\r\u0006\u0002@/\")\u0001\f\u0002a\u00013\u00069QM\\1cY\u0016$\u0007C\u0001\u000e[\u0013\tY6DA\u0004C_>dW-\u00198\u0002\u0017\u001d,G/V:fe:\u000bW.Z\u000b\u0002=B\u0011q\fZ\u0007\u0002A*\u0011\u0011MY\u0001\u0005Y\u0006twMC\u0001d\u0003\u0011Q\u0017M^1\n\u0005\u0015\u0004'AB*ue&tw-\u0001\ftK:$W*Y5oi\u0016t\u0017M\\2f'R\f'\u000f^3e)\ty\u0004\u000eC\u0003D\r\u0001\u0007\u0011\u000e\u0005\u0002ka6\t1N\u0003\u0002DY*\u0011QN\\\u0001\u0004gBL'BA8\u0012\u0003\u0019)gnZ5oK&\u0011\u0011o\u001b\u0002\u0016\u001b\u0006Lg\u000e^3oC:\u001cWm\u0015;beR,e/\u001a8uQ\t11*\u0001\ftK:$W*Y5oi\u0016t\u0017M\\2f'R|\u0007\u000f]3e)\tyT\u000fC\u0003D\u000f\u0001\u0007a\u000f\u0005\u0002ko&\u0011\u0001p\u001b\u0002\u0015\u001b\u0006Lg\u000e^3oC:\u001cWm\u0015;pa\u00163XM\u001c;)\u0005\u001dY\u0015a\u00058pi&4\u0017pQ5t\u0013\u001atu\u000e^#naRLHCB }\u0003\u000f\tY\u0003C\u0003~\u0011\u0001\u0007a0\u0001\u0005f]\u0012\u0004x.\u001b8u!\ry\u00181A\u0007\u0003\u0003\u0003Q!\u0001D\b\n\t\u0005\u0015\u0011\u0011\u0001\u0002\u0013/\u0016\u00147k\\2lKR,e\u000e\u001a9pS:$8\u000fC\u0004\u0002\n!\u0001\r!a\u0003\u0002\u0007\rL7\u000f\u0005\u0004\u0002\u000e\u0005M\u0011qC\u0007\u0003\u0003\u001fQ1!!\u0005c\u0003\u0011)H/\u001b7\n\t\u0005U\u0011q\u0002\u0002\u000b\u0007>dG.Z2uS>t\u0007\u0003BA\r\u0003Oi!!a\u0007\u000b\t\u0005u\u0011qD\u0001\u0004k\u0012l'\u0002BA\u0011\u0003G\t1!\u00199j\u0015\r\t)#E\u0001\u0007a2,x-\u001b8\n\t\u0005%\u00121\u0004\u0002\u0012\u0007>tg-[4ve\u0006$\u0018n\u001c8Ji\u0016l\u0007bBA\u0017\u0011\u0001\u0007\u0011qF\u0001\tkN,'O\\1nKB!\u0011\u0011GA \u001d\u0011\t\u0019$a\u000f\u0011\u0007\u0005U2$\u0004\u0002\u00028)\u0019\u0011\u0011H\f\u0002\rq\u0012xn\u001c;?\u0013\r\tidG\u0001\u0007!J,G-\u001a4\n\u0007\u0015\f\tEC\u0002\u0002>m\t\u0011D\\8uS\u001aLx+\u001b;i\u0013R,Wn]%g\u001d>$X)\u001c9usV!\u0011qIA+)\u001dy\u0014\u0011JA&\u0003OBQ!`\u0005A\u0002yDq!!\u0014\n\u0001\u0004\ty%A\u0003ji\u0016l7\u000f\u0005\u0004\u0002\u000e\u0005M\u0011\u0011\u000b\t\u0005\u0003'\n)\u0006\u0004\u0001\u0005\u000f\u0005]\u0013B1\u0001\u0002Z\t\tA+\u0005\u0003\u0002\\\u0005\u0005\u0004c\u0001\u000e\u0002^%\u0019\u0011qL\u000e\u0003\u000f9{G\u000f[5oOB\u0019!$a\u0019\n\u0007\u0005\u00154DA\u0002B]fDq!!\f\n\u0001\u0004\ty\u0003K\u0002\u0001\u0003W\u0002B!!\u001c\u0002t5\u0011\u0011q\u000e\u0006\u0004\u0003c2\u0013AC:uKJ,w\u000e^=qK&!\u0011QOA8\u0005)\u0019uN\u001c;s_2dWM\u001d")
public class WebSocketMessagesSender {
    @Autowired
    private final SimpMessagingTemplate messageTemplate;

    @Subscribe
    public void sendCiChangeSetMessages(ChangeSetEvent event) {
        String username = (String)event.username().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.getUserName());
        this.notifyCisIfNotEmpty(WebSocketEndpoints.TOPIC_CI_CREATE, event.createCis(), username);
        this.notifyCisIfNotEmpty(WebSocketEndpoints.TOPIC_CI_UPDATE, event.updateCis(), username);
        this.notifyWithItemsIfNotEmpty(WebSocketEndpoints.TOPIC_CI_DELETE, event.deleteCiIds(), username);
        this.notifyWithItemsIfNotEmpty(WebSocketEndpoints.TOPIC_CI_RENAME, event.renameCis(), username);
        this.notifyWithItemsIfNotEmpty(WebSocketEndpoints.TOPIC_CI_MOVE, event.moveCis(), username);
        this.notifyWithItemsIfNotEmpty(WebSocketEndpoints.TOPIC_CI_COPY, event.copyCis(), username);
    }

    private void notifyAboutMaintenanceModeChange(boolean enabled) {
        this.messageTemplate.convertAndSend((Object)WebSocketEndpoints.TOPIC_MAINTENANCE.getName(), (Object)BoxesRunTime.boxToBoolean((boolean)enabled));
    }

    private String getUserName() {
        return SecurityContextHolder.getContext().getAuthentication().getName();
    }

    @Subscribe
    public void sendMaintenanceStarted(MaintenanceStartEvent event) {
        this.notifyAboutMaintenanceModeChange(true);
    }

    @Subscribe
    public void sendMaintenanceStopped(MaintenanceStopEvent event) {
        this.notifyAboutMaintenanceModeChange(false);
    }

    private void notifyCisIfNotEmpty(WebSocketEndpoints endpoint, Collection<ConfigurationItem> cis, String username) {
        Collection items = (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(cis).asScala()).map((Function1 & Serializable & scala.Serializable)ci -> new ConfigurationItemId(ci.getId(), ci.getType()), Iterable$.MODULE$.canBuildFrom())).toList()).asJava();
        this.notifyWithItemsIfNotEmpty(endpoint, items, username);
    }

    private <T> void notifyWithItemsIfNotEmpty(WebSocketEndpoints endpoint, Collection<T> items, String username) {
        block0: {
            if (items.isEmpty()) break block0;
            this.messageTemplate.convertAndSendToUser(username, endpoint.getName(), items);
        }
    }

    public WebSocketMessagesSender(@Autowired SimpMessagingTemplate messageTemplate) {
        this.messageTemplate = messageTemplate;
        EventBusHolder.register((Object)this);
    }
}

