/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license.service.aws;

import com.xebialabs.license.License;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.LicenseVerificationException;
import com.xebialabs.license.service.BaseLicenseService;
import com.xebialabs.license.service.LicenseCiCounterFactory;
import com.xebialabs.license.service.aws.LicenseAWSNonceException;
import java.util.UUID;
import org.joda.time.Period;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001!4Qa\u0004\t\u0002\u0002mAQ\u0001\t\u0001\u0005\u0002\u0005B\u0001\"\u0006\u0001A\u0002\u0013\u0005\u0001\u0003\n\u0005\t_\u0001\u0001\r\u0011\"\u0001\u0011a!1a\u0007\u0001Q!\n\u0015Bqa\u000e\u0001C\u0002\u0013\u0005\u0001\b\u0003\u0004E\u0001\u0001\u0006I!\u000f\u0005\u0006\u000b\u00021\tA\u0012\u0005\u0006\u000f\u0002!\t\u0005\u0013\u0005\u0006\u0013\u0002!\tE\u0013\u0005\u0006\u001d\u0002!\te\u0014\u0005\u0006+\u0002!\tE\u0016\u0005\u0006C\u0002!\tE\u0019\u0005\u0006G\u0002!\t\u0005\u001a\u0005\u0006K\u0002!\tE\u001a\u0002\u0016\u0005\u0006\u001cX-Q,T\u0019&\u001cWM\\:f'\u0016\u0014h/[2f\u0015\t\t\"#A\u0002boNT!a\u0005\u000b\u0002\u000fM,'O^5dK*\u0011QCF\u0001\bY&\u001cWM\\:f\u0015\t9\u0002$A\u0005yK\nL\u0017\r\\1cg*\t\u0011$A\u0002d_6\u001c\u0001a\u0005\u0002\u00019A\u0011QDH\u0007\u0002%%\u0011qD\u0005\u0002\u0013\u0005\u0006\u001cX\rT5dK:\u001cXmU3sm&\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0002EA\u00111\u0005A\u0007\u0002!U\tQ\u0005E\u0002'S-j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!f\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00051jS\"\u0001\u000b\n\u00059\"\"a\u0002'jG\u0016t7/Z\u0001\fY&\u001cWM\\:f?\u0012*\u0017\u000f\u0006\u00022iA\u0011aEM\u0005\u0003g\u001d\u0012A!\u00168ji\"9QgAA\u0001\u0002\u0004)\u0013a\u0001=%c\u0005AA.[2f]N,\u0007%A\u0003o_:\u001cW-F\u0001:!\tQ\u0014I\u0004\u0002<\u007fA\u0011AhJ\u0007\u0002{)\u0011aHG\u0001\u0007yI|w\u000e\u001e \n\u0005\u0001;\u0013A\u0002)sK\u0012,g-\u0003\u0002C\u0007\n11\u000b\u001e:j]\u001eT!\u0001Q\u0014\u0002\r9|gnY3!\u0003Y9W\r^(sS:LG/[1mSj,G*[2f]N,W#A\u0016\u0002\u0015\u001d,G\u000fT5dK:\u001cX\rF\u0001,\u0003AI7\u000fT5dK:\u001cX-\u0012=qSJ,G\rF\u0001L!\t1C*\u0003\u0002NO\t9!i\\8mK\u0006t\u0017AC5oSRL\u0017\r\\5{KR\u0011\u0011\u0007\u0015\u0005\u0006#*\u0001\rAU\u0001\u0011G&\u001cu.\u001e8uKJ4\u0015m\u0019;pef\u0004\"!H*\n\u0005Q\u0013\"a\u0006'jG\u0016t7/Z\"j\u0007>,h\u000e^3s\r\u0006\u001cGo\u001c:z\u000399W\r\u001e,bY&$\u0007+\u001a:j_\u0012$\u0012a\u0016\t\u00031~k\u0011!\u0017\u0006\u00035n\u000bA\u0001^5nK*\u0011A,X\u0001\u0005U>$\u0017MC\u0001_\u0003\ry'oZ\u0005\u0003Af\u0013a\u0001U3sS>$\u0017AC4fiB\u0013x\u000eZ;diR\t\u0011(\u0001\u0004sK2|\u0017\r\u001a\u000b\u0002c\u0005Aa/\u00197jI\u0006$X\r\u0006\u00022O\")QC\u0004a\u0001W\u0001")
public abstract class BaseAWSLicenseService
extends BaseLicenseService {
    private Option<License> license = None$.MODULE$;
    private final String nonce = UUID.randomUUID().toString();

    public Option<License> license() {
        return this.license;
    }

    public void license_$eq(Option<License> x$1) {
        this.license = x$1;
    }

    public String nonce() {
        return this.nonce;
    }

    public abstract License getOrinitializeLicense();

    public License getLicense() {
        return this.getOrinitializeLicense();
    }

    public boolean isLicenseExpired() {
        return this.license().forall((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isDateExpired()));
    }

    public void initialize(LicenseCiCounterFactory ciCounterFactory) {
        this.ciCounterFactory = ciCounterFactory;
        this.reLoadCiCounter(this.getOrinitializeLicense());
    }

    public Period getValidPeriod() {
        return Period.months((int)1);
    }

    public String getProduct() {
        return (String)this.license().map((Function1 & java.io.Serializable & Serializable)x$2 -> x$2.getStringValue(LicenseProperty.PRODUCT)).get();
    }

    public void reload() {
        License l = this.getOrinitializeLicense();
        this.reLoadCiCounter(l);
        this.validate();
    }

    @Override
    public void validate(License license) {
        if (!license.hasLicenseProperty(LicenseProperty.AWS_NONCE)) {
            throw new LicenseVerificationException(new StringBuilder(54).append("The current license does not have the '").append(LicenseProperty.AWS_NONCE).append("' property set.").toString());
        }
        if (!license.getStringValue(LicenseProperty.AWS_NONCE).equals(this.nonce())) {
            throw new LicenseAWSNonceException("The current license is for a different instance than your own.");
        }
        super.validate(license);
    }
}

