/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import io.netty.buffer.ByteBuf;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.logs.ActiveMQUtilBundle;
import org.jboss.logging.Logger;

public class ByteUtil {
    public static final String NON_ASCII_STRING = "@@@@@";
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    private static final String prefix = "^\\s*(\\d+)\\s*";
    private static final String suffix = "(b)?\\s*$";
    private static final Pattern ONE = Pattern.compile("^\\s*(\\d+)\\s*(b)?\\s*$", 2);
    private static final Pattern KILO = Pattern.compile("^\\s*(\\d+)\\s*k(b)?\\s*$", 2);
    private static final Pattern MEGA = Pattern.compile("^\\s*(\\d+)\\s*m(b)?\\s*$", 2);
    private static final Pattern GIGA = Pattern.compile("^\\s*(\\d+)\\s*g(b)?\\s*$", 2);

    public static void debugFrame(Logger logger2, String message, ByteBuf byteIn) {
        if (logger2.isTraceEnabled()) {
            int location = byteIn.readerIndex();
            byte[] frame = new byte[byteIn.writerIndex()];
            byteIn.readBytes(frame);
            try {
                logger2.trace((Object)(message + "\n" + ByteUtil.formatGroup(ByteUtil.bytesToHex(frame), 8, 16)));
            }
            catch (Exception e) {
                logger2.warn((Object)e.getMessage(), (Throwable)e);
            }
            byteIn.readerIndex(location);
        }
    }

    public static String formatGroup(String str, int groupSize, int lineBreak) {
        StringBuffer buffer = new StringBuffer();
        int line = 1;
        buffer.append("/*  1 */ \"");
        for (int i = 0; i < str.length(); i += groupSize) {
            buffer.append(str.substring(i, i + Math.min(str.length() - i, groupSize)));
            if ((i + groupSize) % lineBreak == 0) {
                buffer.append("\" +\n/* ");
                if (++line < 10) {
                    buffer.append(" ");
                }
                buffer.append(Integer.toString(line) + " */ \"");
                continue;
            }
            if ((i + groupSize) % groupSize != 0 || str.length() - i <= groupSize) continue;
            buffer.append("\" + \"");
        }
        buffer.append("\";");
        return buffer.toString();
    }

    public static String maxString(String value, int size) {
        if (value.length() < size) {
            return value;
        }
        return value.substring(0, size / 2) + " ... " + value.substring(value.length() - size / 2);
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String bytesToHex(byte[] bytes, int groupSize) {
        if (bytes == null) {
            return "NULL";
        }
        if (bytes.length == 0) {
            return "[]";
        }
        char[] hexChars = new char[bytes.length * 2 + ByteUtil.numberOfGroups(bytes, groupSize)];
        int outPos = 0;
        for (int j = 0; j < bytes.length; ++j) {
            if (j > 0 && j % groupSize == 0) {
                hexChars[outPos++] = 32;
            }
            int v = bytes[j] & 0xFF;
            hexChars[outPos++] = hexArray[v >>> 4];
            hexChars[outPos++] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String toSimpleString(byte[] bytes) {
        SimpleString simpleString = new SimpleString(bytes);
        String value = simpleString.toString();
        for (char c : value.toCharArray()) {
            if (c >= ' ' && c <= '\u007f') continue;
            return NON_ASCII_STRING;
        }
        return value;
    }

    private static int numberOfGroups(byte[] bytes, int groupSize) {
        int groups = bytes.length / groupSize;
        if (bytes.length % groupSize == 0) {
            --groups;
        }
        return groups;
    }

    public static final byte[] intToBytes(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public static int bytesToInt(byte[] b) {
        return b[3] & 0xFF | (b[2] & 0xFF) << 8 | (b[1] & 0xFF) << 16 | (b[0] & 0xFF) << 24;
    }

    public static byte[] hexToBytes(String hexStr) {
        byte[] bytes = new byte[hexStr.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(hexStr.substring(2 * i, 2 * i + 2), 16);
        }
        return bytes;
    }

    public static String readLine(ActiveMQBuffer buffer) {
        StringBuilder sb = new StringBuilder("");
        char c = buffer.readChar();
        while (c != '\n') {
            sb.append(c);
            c = buffer.readChar();
        }
        return sb.toString();
    }

    public static byte[] getActiveArray(ByteBuffer buffer) {
        byte[] ret = new byte[buffer.remaining()];
        if (buffer.hasArray()) {
            byte[] array = buffer.array();
            System.arraycopy(array, buffer.arrayOffset() + buffer.position(), ret, 0, ret.length);
        } else {
            buffer.slice().get(ret);
        }
        return ret;
    }

    public static long convertTextBytes(String text) {
        try {
            Matcher m = ONE.matcher(text);
            if (m.matches()) {
                return Long.parseLong(m.group(1));
            }
            m = KILO.matcher(text);
            if (m.matches()) {
                return Long.parseLong(m.group(1)) * 1024L;
            }
            m = MEGA.matcher(text);
            if (m.matches()) {
                return Long.parseLong(m.group(1)) * 1024L * 1024L;
            }
            m = GIGA.matcher(text);
            if (m.matches()) {
                return Long.parseLong(m.group(1)) * 1024L * 1024L * 1024L;
            }
            return Long.parseLong(text);
        }
        catch (NumberFormatException e) {
            throw ActiveMQUtilBundle.BUNDLE.failedToParseLong(text);
        }
    }

    public static boolean equals(byte[] left, byte[] right) {
        return ByteUtil.equals(left, right, 0, right.length);
    }

    public static boolean equals(byte[] left, byte[] right, int rightOffset, int rightLength) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.length != rightLength) {
            return false;
        }
        if (PlatformDependent.isUnaligned() && PlatformDependent.hasUnsafe()) {
            return ByteUtil.equalsUnsafe(left, right, rightOffset, rightLength);
        }
        return ByteUtil.equalsSafe(left, right, rightOffset, rightLength);
    }

    private static boolean equalsSafe(byte[] left, byte[] right, int rightOffset, int rightLength) {
        for (int i = 0; i < rightLength; ++i) {
            if (left[i] == right[rightOffset + i]) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsUnsafe(byte[] left, byte[] right, int rightOffset, int rightLength) {
        int i;
        int longCount = rightLength >>> 3;
        int bytesCount = rightLength & 7;
        int bytesIndex = rightOffset;
        int charsIndex = 0;
        for (i = 0; i < longCount; ++i) {
            long bytesLong;
            long charsLong = PlatformDependent.getLong((byte[])left, (int)charsIndex);
            if (charsLong != (bytesLong = PlatformDependent.getLong((byte[])right, (int)bytesIndex))) {
                return false;
            }
            bytesIndex += 8;
            charsIndex += 8;
        }
        for (i = 0; i < bytesCount; ++i) {
            byte bytesByte;
            byte charsByte = PlatformDependent.getByte((byte[])left, (int)charsIndex);
            if (charsByte != (bytesByte = PlatformDependent.getByte((byte[])right, (int)bytesIndex))) {
                return false;
            }
            ++bytesIndex;
            ++charsIndex;
        }
        return true;
    }

    public static boolean equals(byte[] bytes, ByteBuf byteBuf, int offset, int length) {
        if (bytes.length != length) {
            return false;
        }
        if (PlatformDependent.isUnaligned() && PlatformDependent.hasUnsafe()) {
            if (offset + length > byteBuf.writerIndex()) {
                throw new IndexOutOfBoundsException();
            }
            if (byteBuf.hasArray()) {
                return ByteUtil.equals(bytes, byteBuf.array(), byteBuf.arrayOffset() + offset, length);
            }
            if (byteBuf.hasMemoryAddress()) {
                return ByteUtil.equalsOffHeap(bytes, byteBuf.memoryAddress(), offset, length);
            }
        }
        return ByteUtil.equalsOnHeap(bytes, byteBuf, offset, length);
    }

    private static boolean equalsOnHeap(byte[] bytes, ByteBuf byteBuf, int offset, int length) {
        if (bytes.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (bytes[i] == byteBuf.getByte(offset + i)) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsOffHeap(byte[] bytes, long address, int offset, int length) {
        int i;
        int longCount = length >>> 3;
        int bytesCount = length & 7;
        long bytesAddress = address + (long)offset;
        int charsIndex = 0;
        for (i = 0; i < longCount; ++i) {
            long bytesLong;
            long charsLong = PlatformDependent.getLong((byte[])bytes, (int)charsIndex);
            if (charsLong != (bytesLong = PlatformDependent.getLong((long)bytesAddress))) {
                return false;
            }
            bytesAddress += 8L;
            charsIndex += 8;
        }
        for (i = 0; i < bytesCount; ++i) {
            byte bytesByte;
            byte charsByte = PlatformDependent.getByte((byte[])bytes, (int)charsIndex);
            if (charsByte != (bytesByte = PlatformDependent.getByte((long)bytesAddress))) {
                return false;
            }
            ++bytesAddress;
            ++charsIndex;
        }
        return true;
    }

    public static int intFromBytes(byte b1, byte b2, byte b3, byte b4) {
        return b1 << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
    }

    public static void zeros(ByteBuffer buffer) {
        ByteUtil.uncheckedZeros(buffer, 0, buffer.capacity());
    }

    public static void zeros(ByteBuffer buffer, int offset, int bytes) {
        if (offset < 0 || bytes < 0) {
            throw new IllegalArgumentException();
        }
        int capacity = buffer.capacity();
        if (offset >= capacity || offset + bytes > capacity) {
            throw new IndexOutOfBoundsException();
        }
        ByteUtil.uncheckedZeros(buffer, offset, bytes);
    }

    private static void uncheckedZeros(ByteBuffer buffer, int offset, int bytes) {
        if (buffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        boolean zero = false;
        if (buffer.isDirect() && PlatformDependent.hasUnsafe()) {
            PlatformDependent.setMemory((long)(PlatformDependent.directBufferAddress((ByteBuffer)buffer) + (long)offset), (long)bytes, (byte)0);
        } else if (buffer.hasArray()) {
            int arrayOffset = buffer.arrayOffset();
            int start = arrayOffset + offset;
            Arrays.fill(buffer.array(), start, start + bytes, (byte)0);
        } else {
            for (int i = 0; i < bytes; ++i) {
                buffer.put(i + offset, (byte)0);
            }
        }
    }
}

