/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.jwt.crypto.sign;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;

final class EllipticCurveKeyHelper {
    EllipticCurveKeyHelper() {
    }

    static ECPublicKey createPublicKey(BigInteger x, BigInteger y, String curve) {
        ECNamedCurveParameterSpec curveParameterSpec = ECNamedCurveTable.getParameterSpec((String)curve);
        if (curveParameterSpec == null) {
            throw new IllegalArgumentException("Unsupported named curve: " + curve);
        }
        ECNamedCurveSpec parameterSpec = new ECNamedCurveSpec(curveParameterSpec.getName(), curveParameterSpec.getCurve(), curveParameterSpec.getG(), curveParameterSpec.getN());
        ECPublicKeySpec publicKeySpec = new ECPublicKeySpec(new ECPoint(x, y), (ECParameterSpec)parameterSpec);
        try {
            return (ECPublicKey)KeyFactory.getInstance("EC").generatePublic(publicKeySpec);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

