/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.jwt;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

class HeaderParameters {
    final String alg;
    final Map<String, String> map;
    final String typ = "JWT";

    HeaderParameters(String alg) {
        this(new LinkedHashMap<String, String>(Collections.singletonMap("alg", alg)));
    }

    HeaderParameters(Map<String, String> map) {
        String alg = map.get("alg");
        String typ = map.get("typ");
        if (typ != null && !"JWT".equalsIgnoreCase(typ)) {
            throw new IllegalArgumentException("typ is not \"JWT\"");
        }
        map.remove("alg");
        map.remove("typ");
        this.map = map;
        if (alg == null) {
            throw new IllegalArgumentException("alg is required");
        }
        this.alg = alg;
    }
}

