/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.AvailableCounterHandler;
import io.aeron.AvailableImageHandler;
import io.aeron.ClientConductor;
import io.aeron.CncFileDescriptor;
import io.aeron.CommonContext;
import io.aeron.ConcurrentPublication;
import io.aeron.Counter;
import io.aeron.DriverProxy;
import io.aeron.ExclusivePublication;
import io.aeron.LogBuffersFactory;
import io.aeron.MappedLogBuffersFactory;
import io.aeron.Subscription;
import io.aeron.UnavailableCounterHandler;
import io.aeron.UnavailableImageHandler;
import io.aeron.exceptions.AeronException;
import io.aeron.exceptions.DriverTimeoutException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.SystemUtil;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.SleepingMillisIdleStrategy;
import org.agrona.concurrent.SystemEpochClock;
import org.agrona.concurrent.SystemNanoClock;
import org.agrona.concurrent.broadcast.BroadcastReceiver;
import org.agrona.concurrent.broadcast.CopyBroadcastReceiver;
import org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;
import org.agrona.concurrent.ringbuffer.RingBuffer;
import org.agrona.concurrent.status.CountersReader;

public class Aeron
implements AutoCloseable {
    public static final int NULL_VALUE = -1;
    private static final AtomicIntegerFieldUpdater<Aeron> IS_CLOSED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Aeron.class, "isClosed");
    private volatile int isClosed;
    private final long clientId;
    private final ClientConductor conductor;
    private final RingBuffer commandBuffer;
    private final AgentInvoker conductorInvoker;
    private final AgentRunner conductorRunner;
    private final Context ctx;

    Aeron(Context ctx) {
        ctx.conclude();
        this.ctx = ctx;
        this.clientId = ctx.clientId();
        this.commandBuffer = ctx.toDriverBuffer();
        this.conductor = new ClientConductor(ctx);
        if (ctx.useConductorAgentInvoker()) {
            this.conductorInvoker = new AgentInvoker(ctx.errorHandler(), null, (Agent)this.conductor);
            this.conductorRunner = null;
        } else {
            this.conductorInvoker = null;
            this.conductorRunner = new AgentRunner(ctx.idleStrategy(), ctx.errorHandler(), null, (Agent)this.conductor);
        }
    }

    public static Aeron connect() {
        return Aeron.connect(new Context());
    }

    public static Aeron connect(Context ctx) {
        try {
            Aeron aeron = new Aeron(ctx);
            if (ctx.useConductorAgentInvoker()) {
                aeron.conductorInvoker.start();
            } else {
                AgentRunner.startOnThread((AgentRunner)aeron.conductorRunner, (ThreadFactory)ctx.threadFactory);
            }
            return aeron;
        }
        catch (Exception ex) {
            ctx.close();
            throw ex;
        }
    }

    public void printCounters(PrintStream out) {
        CountersReader counters = this.countersReader();
        counters.forEach((value, id, label) -> out.format("%3d: %,20d - %s%n", id, value, label));
    }

    public boolean isClosed() {
        return 1 == this.isClosed;
    }

    public Context context() {
        return this.ctx;
    }

    public long clientId() {
        return this.clientId;
    }

    public AgentInvoker conductorAgentInvoker() {
        return this.conductorInvoker;
    }

    @Override
    public void close() {
        if (IS_CLOSED_UPDATER.compareAndSet(this, 0, 1)) {
            if (null != this.conductorRunner) {
                this.conductorRunner.close();
            } else {
                this.conductorInvoker.close();
            }
        }
    }

    public ConcurrentPublication addPublication(String channel, int streamId) {
        return this.conductor.addPublication(channel, streamId);
    }

    public ExclusivePublication addExclusivePublication(String channel, int streamId) {
        return this.conductor.addExclusivePublication(channel, streamId);
    }

    public Subscription addSubscription(String channel, int streamId) {
        return this.conductor.addSubscription(channel, streamId);
    }

    public Subscription addSubscription(String channel, int streamId, AvailableImageHandler availableImageHandler, UnavailableImageHandler unavailableImageHandler) {
        return this.conductor.addSubscription(channel, streamId, availableImageHandler, unavailableImageHandler);
    }

    public long nextCorrelationId() {
        if (1 == this.isClosed) {
            throw new AeronException("client is closed");
        }
        return this.commandBuffer.nextCorrelationId();
    }

    public CountersReader countersReader() {
        if (1 == this.isClosed) {
            throw new AeronException("client is closed");
        }
        return this.conductor.countersReader();
    }

    public Counter addCounter(int typeId, DirectBuffer keyBuffer, int keyOffset, int keyLength, DirectBuffer labelBuffer, int labelOffset, int labelLength) {
        return this.conductor.addCounter(typeId, keyBuffer, keyOffset, keyLength, labelBuffer, labelOffset, labelLength);
    }

    public Counter addCounter(int typeId, String label) {
        return this.conductor.addCounter(typeId, label);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static MappedByteBuffer waitForFileMapping(File cncFile, long deadlineMs, EpochClock epochClock) {
        try (FileChannel fileChannel = FileChannel.open(cncFile.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);){
            while (fileChannel.size() < (long)(CncFileDescriptor.CNC_VERSION_FIELD_OFFSET + 4)) {
                if (epochClock.time() > deadlineMs) {
                    throw new AeronException("CnC file is created but not populated");
                }
                Aeron.sleep(16L);
            }
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, fileChannel.size());
            return mappedByteBuffer;
        }
        catch (IOException ex) {
            throw new AeronException("cannot open CnC file", ex);
        }
    }

    static void sleep(long durationMs) {
        try {
            Thread.sleep(durationMs);
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
    }

    public static class Context
    extends CommonContext {
        private long clientId;
        private boolean useConductorAgentInvoker = false;
        private AgentInvoker driverAgentInvoker;
        private Lock clientLock;
        private EpochClock epochClock;
        private NanoClock nanoClock;
        private IdleStrategy idleStrategy;
        private CopyBroadcastReceiver toClientBuffer;
        private RingBuffer toDriverBuffer;
        private DriverProxy driverProxy;
        private MappedByteBuffer cncByteBuffer;
        private AtomicBuffer cncMetaDataBuffer;
        private LogBuffersFactory logBuffersFactory;
        private ErrorHandler errorHandler;
        private AvailableImageHandler availableImageHandler;
        private UnavailableImageHandler unavailableImageHandler;
        private AvailableCounterHandler availableCounterHandler;
        private UnavailableCounterHandler unavailableCounterHandler;
        private long keepAliveInterval = Configuration.KEEPALIVE_INTERVAL_NS;
        private long interServiceTimeout = 0L;
        private long resourceLingerDurationNs = Configuration.resourceLingerDurationNs();
        private ThreadFactory threadFactory = Thread::new;

        @Override
        public Context clone() {
            return (Context)super.clone();
        }

        @Override
        public Context conclude() {
            super.conclude();
            if (null == this.clientLock) {
                this.clientLock = new ReentrantLock();
            }
            if (null == this.epochClock) {
                this.epochClock = new SystemEpochClock();
            }
            if (null == this.nanoClock) {
                this.nanoClock = new SystemNanoClock();
            }
            if (null == this.idleStrategy) {
                this.idleStrategy = new SleepingMillisIdleStrategy(16L);
            }
            if (this.cncFile() != null) {
                this.connectToDriver();
            }
            if (null == this.toDriverBuffer) {
                this.toDriverBuffer = new ManyToOneRingBuffer((AtomicBuffer)CncFileDescriptor.createToDriverBuffer(this.cncByteBuffer, (DirectBuffer)this.cncMetaDataBuffer));
            }
            if (null == this.toClientBuffer) {
                this.toClientBuffer = new CopyBroadcastReceiver(new BroadcastReceiver((AtomicBuffer)CncFileDescriptor.createToClientsBuffer(this.cncByteBuffer, (DirectBuffer)this.cncMetaDataBuffer)));
            }
            if (this.countersMetaDataBuffer() == null) {
                this.countersMetaDataBuffer(CncFileDescriptor.createCountersMetaDataBuffer(this.cncByteBuffer, (DirectBuffer)this.cncMetaDataBuffer));
            }
            if (this.countersValuesBuffer() == null) {
                this.countersValuesBuffer(CncFileDescriptor.createCountersValuesBuffer(this.cncByteBuffer, (DirectBuffer)this.cncMetaDataBuffer));
            }
            this.interServiceTimeout = CncFileDescriptor.clientLivenessTimeout((DirectBuffer)this.cncMetaDataBuffer);
            if (null == this.logBuffersFactory) {
                this.logBuffersFactory = new MappedLogBuffersFactory();
            }
            if (null == this.errorHandler) {
                this.errorHandler = Configuration.DEFAULT_ERROR_HANDLER;
            }
            if (null == this.driverProxy) {
                this.clientId = this.toDriverBuffer.nextCorrelationId();
                this.driverProxy = new DriverProxy(this.toDriverBuffer, this.clientId);
            }
            return this;
        }

        public long clientId() {
            return this.clientId;
        }

        public Context useConductorAgentInvoker(boolean useConductorAgentInvoker) {
            this.useConductorAgentInvoker = useConductorAgentInvoker;
            return this;
        }

        public boolean useConductorAgentInvoker() {
            return this.useConductorAgentInvoker;
        }

        public Context driverAgentInvoker(AgentInvoker driverAgentInvoker) {
            this.driverAgentInvoker = driverAgentInvoker;
            return this;
        }

        public AgentInvoker driverAgentInvoker() {
            return this.driverAgentInvoker;
        }

        public Context clientLock(Lock lock) {
            this.clientLock = lock;
            return this;
        }

        public Lock clientLock() {
            return this.clientLock;
        }

        public Context epochClock(EpochClock clock) {
            this.epochClock = clock;
            return this;
        }

        public EpochClock epochClock() {
            return this.epochClock;
        }

        public Context nanoClock(NanoClock clock) {
            this.nanoClock = clock;
            return this;
        }

        public NanoClock nanoClock() {
            return this.nanoClock;
        }

        public Context idleStrategy(IdleStrategy idleStrategy) {
            this.idleStrategy = idleStrategy;
            return this;
        }

        public IdleStrategy idleStrategy() {
            return this.idleStrategy;
        }

        Context toClientBuffer(CopyBroadcastReceiver toClientBuffer) {
            this.toClientBuffer = toClientBuffer;
            return this;
        }

        public CopyBroadcastReceiver toClientBuffer() {
            return this.toClientBuffer;
        }

        Context toDriverBuffer(RingBuffer toDriverBuffer) {
            this.toDriverBuffer = toDriverBuffer;
            return this;
        }

        public RingBuffer toDriverBuffer() {
            return this.toDriverBuffer;
        }

        Context driverProxy(DriverProxy driverProxy) {
            this.driverProxy = driverProxy;
            return this;
        }

        public DriverProxy driverProxy() {
            return this.driverProxy;
        }

        Context logBuffersFactory(LogBuffersFactory logBuffersFactory) {
            this.logBuffersFactory = logBuffersFactory;
            return this;
        }

        public LogBuffersFactory logBuffersFactory() {
            return this.logBuffersFactory;
        }

        public Context errorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public ErrorHandler errorHandler() {
            return this.errorHandler;
        }

        public Context availableImageHandler(AvailableImageHandler handler) {
            this.availableImageHandler = handler;
            return this;
        }

        public AvailableImageHandler availableImageHandler() {
            return this.availableImageHandler;
        }

        public Context unavailableImageHandler(UnavailableImageHandler handler) {
            this.unavailableImageHandler = handler;
            return this;
        }

        public UnavailableImageHandler unavailableImageHandler() {
            return this.unavailableImageHandler;
        }

        public Context availableCounterHandler(AvailableCounterHandler handler) {
            this.availableCounterHandler = handler;
            return this;
        }

        public AvailableCounterHandler availableCounterHandler() {
            return this.availableCounterHandler;
        }

        public Context unavailableCounterHandler(UnavailableCounterHandler handler) {
            this.unavailableCounterHandler = handler;
            return this;
        }

        public UnavailableCounterHandler unavailableCounterHandler() {
            return this.unavailableCounterHandler;
        }

        public Context keepAliveInterval(long value) {
            this.keepAliveInterval = value;
            return this;
        }

        public long keepAliveInterval() {
            return this.keepAliveInterval;
        }

        @Override
        public Context driverTimeoutMs(long value) {
            super.driverTimeoutMs(value);
            return this;
        }

        Context interServiceTimeout(long interServiceTimeout) {
            this.interServiceTimeout = interServiceTimeout;
            return this;
        }

        public long interServiceTimeout() {
            return this.interServiceTimeout;
        }

        public Context resourceLingerDurationNs(long resourceLingerDurationNs) {
            this.resourceLingerDurationNs = resourceLingerDurationNs;
            return this;
        }

        public long resourceLingerDurationNs() {
            return this.resourceLingerDurationNs;
        }

        @Override
        public Context aeronDirectoryName(String dirName) {
            super.aeronDirectoryName(dirName);
            return this;
        }

        public Context threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public ThreadFactory threadFactory() {
            return this.threadFactory;
        }

        @Override
        public void close() {
            MappedByteBuffer cncByteBuffer = this.cncByteBuffer;
            this.cncByteBuffer = null;
            IoUtil.unmap((MappedByteBuffer)cncByteBuffer);
            super.close();
        }

        private void connectToDriver() {
            long startTimeMs = this.epochClock.time();
            long deadlineMs = startTimeMs + this.driverTimeoutMs();
            File cncFile = this.cncFile();
            while (null == this.toDriverBuffer) {
                int cncVersion;
                while (!cncFile.exists() || cncFile.length() <= 0L) {
                    if (this.epochClock.time() > deadlineMs) {
                        throw new DriverTimeoutException("CnC file not created: " + cncFile.getAbsolutePath());
                    }
                    Aeron.sleep(16L);
                }
                this.cncByteBuffer = Aeron.waitForFileMapping(cncFile, deadlineMs, this.epochClock);
                this.cncMetaDataBuffer = CncFileDescriptor.createMetaDataBuffer(this.cncByteBuffer);
                while (0 == (cncVersion = this.cncMetaDataBuffer.getIntVolatile(CncFileDescriptor.cncVersionOffset(0)))) {
                    if (this.epochClock.time() > deadlineMs) {
                        throw new DriverTimeoutException("CnC file is created but not initialised");
                    }
                    Aeron.sleep(1L);
                }
                if (15 != cncVersion) {
                    throw new AeronException("CnC file version not supported: version=" + cncVersion);
                }
                ManyToOneRingBuffer ringBuffer = new ManyToOneRingBuffer((AtomicBuffer)CncFileDescriptor.createToDriverBuffer(this.cncByteBuffer, (DirectBuffer)this.cncMetaDataBuffer));
                while (0L == ringBuffer.consumerHeartbeatTime()) {
                    if (this.epochClock.time() > deadlineMs) {
                        throw new DriverTimeoutException("no driver heartbeat detected");
                    }
                    Aeron.sleep(1L);
                }
                long timeMs = this.epochClock.time();
                if (ringBuffer.consumerHeartbeatTime() < timeMs - this.driverTimeoutMs()) {
                    if (timeMs > deadlineMs) {
                        throw new DriverTimeoutException("no driver heartbeat detected");
                    }
                    IoUtil.unmap((MappedByteBuffer)this.cncByteBuffer);
                    this.cncByteBuffer = null;
                    this.cncMetaDataBuffer = null;
                    Aeron.sleep(100L);
                    continue;
                }
                this.toDriverBuffer = ringBuffer;
            }
        }
    }

    public static class Configuration {
        static final long IDLE_SLEEP_MS = 16L;
        static final long IDLE_SLEEP_NS = TimeUnit.MILLISECONDS.toNanos(16L);
        static final long KEEPALIVE_INTERVAL_NS = TimeUnit.MILLISECONDS.toNanos(500L);
        public static final String RESOURCE_LINGER_DURATION_PROP_NAME = "aeron.client.resource.linger.duration";
        public static final long RESOURCE_LINGER_DURATION_DEFAULT = TimeUnit.SECONDS.toNanos(3L);
        public static final ErrorHandler DEFAULT_ERROR_HANDLER = throwable -> {
            throwable.printStackTrace();
            if (throwable instanceof DriverTimeoutException) {
                System.err.printf("%n***%n*** timeout from the MediaDriver - is it currently running? Exiting%n***%n", new Object[0]);
                System.exit(-1);
            }
        };

        public static long resourceLingerDurationNs() {
            return SystemUtil.getDurationInNanos((String)RESOURCE_LINGER_DURATION_PROP_NAME, (long)RESOURCE_LINGER_DURATION_DEFAULT);
        }
    }
}

