/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.encryption;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.conversion.Coder;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.security.SecretKeyHolder;
import java.util.Arrays;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.RuntimeCryptoException;

abstract class PasswordEncrypterBase {
    protected Coder coder = null;
    protected final SecretKeyHolder encryptionKeyHolder;

    protected PasswordEncrypterBase(SecretKeyHolder encryptionKeyHolder) {
        this.encryptionKeyHolder = encryptionKeyHolder;
    }

    public String getKeyFingerprint() {
        return this.encryptionKeyHolder.getKeyFingerprint();
    }

    public String decrypt(String encryptedText) {
        Checks.checkArgument((encryptedText != null ? 1 : 0) != 0, (String)"The password is null", (Object[])new Object[0]);
        Checks.checkArgument((boolean)encryptedText.startsWith(this.coder.identifier()), (String)"The password should be Base64 encoded", (Object[])new Object[0]);
        try {
            return this.doDecodeAndDecrypt(encryptedText);
        }
        catch (IllegalStateException e) {
            throw new DeployitException("Could not decrypt the password.");
        }
    }

    public boolean isEncoded(String text) {
        try {
            this.coder.decode(text.getBytes());
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public String ensureDecrypted(String text) {
        if (this.isEncrypted(text)) {
            return this.decrypt(text);
        }
        return text;
    }

    public String ensureEncrypted(String text) {
        if (this.isEncrypted(text)) {
            return text;
        }
        return this.encrypt(text);
    }

    public boolean isEncrypted(String text) {
        if (this.isEncoded(text)) {
            try {
                this.doDecodeAndDecrypt(text);
                return true;
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Could not decrypt Base64 encoded password");
            }
        }
        return false;
    }

    public boolean isEncodedAndDecryptable(String text) {
        if (!this.isEncoded(text)) {
            return false;
        }
        try {
            this.doDecodeAndDecrypt(text);
        }
        catch (IllegalStateException e) {
            return false;
        }
        return true;
    }

    public String encrypt(String plaintext) {
        Checks.checkArgument((plaintext != null ? 1 : 0) != 0, (String)"The password is null", (Object[])new Object[0]);
        Checks.checkArgument((!plaintext.startsWith(this.coder.identifier().substring(0, 4)) ? 1 : 0) != 0, (String)("The password contains the illegal sequence " + this.coder.identifier()), (Object[])new Object[0]);
        try {
            return this.doEncrypt(plaintext);
        }
        catch (IllegalStateException e) {
            throw new DeployitException("Could not encrypt the password.");
        }
    }

    byte[] crypt(byte[] bytes, BufferedBlockCipher cipher) throws IllegalStateException {
        try {
            byte[] processed = new byte[cipher.getOutputSize(bytes.length)];
            int len = cipher.processBytes(bytes, 0, bytes.length, processed, 0);
            len += cipher.doFinal(processed, len);
            return Arrays.copyOfRange(processed, 0, len);
        }
        catch (CryptoException | RuntimeCryptoException e) {
            throw new IllegalStateException(e);
        }
    }

    public String prefix() {
        return this.coder.identifier();
    }

    public abstract String doDecodeAndDecrypt(String var1) throws IllegalStateException;

    public abstract String doEncrypt(String var1) throws IllegalStateException;
}

