/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.index.DocFieldConsumerPerField;
import org.apache.lucene.index.DocFieldConsumerPerThread;
import org.apache.lucene.index.DocFieldProcessorPerThread;
import org.apache.lucene.index.DocInverter;
import org.apache.lucene.index.DocInverterPerField;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.InvertedDocConsumerPerThread;
import org.apache.lucene.index.InvertedDocEndConsumerPerThread;
import org.apache.lucene.index.ReusableStringReader;
import org.apache.lucene.util.AttributeSource;

final class DocInverterPerThread
extends DocFieldConsumerPerThread {
    final DocInverter docInverter;
    final InvertedDocConsumerPerThread consumer;
    final InvertedDocEndConsumerPerThread endConsumer;
    final SingleTokenAttributeSource singleToken = new SingleTokenAttributeSource();
    final DocumentsWriter.DocState docState;
    final FieldInvertState fieldState = new FieldInvertState();
    final ReusableStringReader stringReader = new ReusableStringReader();

    public DocInverterPerThread(DocFieldProcessorPerThread docFieldProcessorPerThread, DocInverter docInverter) {
        this.docInverter = docInverter;
        this.docState = docFieldProcessorPerThread.docState;
        this.consumer = docInverter.consumer.addThread(this);
        this.endConsumer = docInverter.endConsumer.addThread(this);
    }

    public void startDocument() throws IOException {
        this.consumer.startDocument();
        this.endConsumer.startDocument();
    }

    public DocumentsWriter.DocWriter finishDocument() throws IOException {
        this.endConsumer.finishDocument();
        return this.consumer.finishDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abort() {
        try {
            this.consumer.abort();
            Object var2_1 = null;
            this.endConsumer.abort();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.endConsumer.abort();
            throw throwable;
        }
    }

    public DocFieldConsumerPerField addField(FieldInfo fi) {
        return new DocInverterPerField(this, fi);
    }

    static class SingleTokenAttributeSource
    extends AttributeSource {
        final CharTermAttribute termAttribute = this.addAttribute(CharTermAttribute.class);
        final OffsetAttribute offsetAttribute = this.addAttribute(OffsetAttribute.class);

        private SingleTokenAttributeSource() {
        }

        public void reinit(String stringValue, int startOffset, int endOffset) {
            this.termAttribute.setEmpty().append(stringValue);
            this.offsetAttribute.setOffset(startOffset, endOffset);
        }
    }
}

