/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.Configuration;
import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.PendingSetupMessageFromSource;
import io.aeron.driver.PublicationImage;
import io.aeron.driver.media.DataTransportPoller;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.media.ReceiveDestinationUdpTransport;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.status.SystemCounterDescriptor;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import org.agrona.CloseHelper;
import org.agrona.collections.ArrayListUtil;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.OneToOneConcurrentArrayQueue;
import org.agrona.concurrent.status.AtomicCounter;

public class Receiver
implements Agent {
    private final DataTransportPoller dataTransportPoller;
    private final OneToOneConcurrentArrayQueue<Runnable> commandQueue;
    private final AtomicCounter totalBytesReceived;
    private final NanoClock nanoClock;
    private final ArrayList<PublicationImage> publicationImages = new ArrayList();
    private final ArrayList<PendingSetupMessageFromSource> pendingSetupMessages = new ArrayList();
    private final DriverConductorProxy conductorProxy;

    public Receiver(MediaDriver.Context ctx) {
        this.dataTransportPoller = ctx.dataTransportPoller();
        this.commandQueue = ctx.receiverCommandQueue();
        this.totalBytesReceived = ctx.systemCounters().get(SystemCounterDescriptor.BYTES_RECEIVED);
        this.nanoClock = ctx.cachedNanoClock();
        this.conductorProxy = ctx.driverConductorProxy();
    }

    public void onClose() {
        this.dataTransportPoller.close();
    }

    public String roleName() {
        return "receiver";
    }

    public int doWork() {
        int lastIndex;
        int workCount = this.commandQueue.drain(Runnable::run, 10);
        int bytesReceived = this.dataTransportPoller.pollTransports();
        this.totalBytesReceived.getAndAddOrdered((long)bytesReceived);
        long nowNs = this.nanoClock.nanoTime();
        ArrayList<PublicationImage> publicationImages = this.publicationImages;
        for (int i = lastIndex = publicationImages.size() - 1; i >= 0; --i) {
            PublicationImage image = publicationImages.get(i);
            if (image.hasActivityAndNotEndOfStream(nowNs)) {
                workCount += image.sendPendingStatusMessage();
                workCount += image.processPendingLoss();
                workCount += image.initiateAnyRttMeasurements(nowNs);
                continue;
            }
            ArrayListUtil.fastUnorderedRemove(publicationImages, (int)i, (int)lastIndex--);
            image.removeFromDispatcher();
        }
        this.checkPendingSetupMessages(nowNs);
        return workCount + bytesReceived;
    }

    public void addPendingSetupMessage(int sessionId, int streamId, int transportIndex, ReceiveChannelEndpoint channelEndpoint, boolean periodic, InetSocketAddress controlAddress) {
        PendingSetupMessageFromSource cmd = new PendingSetupMessageFromSource(sessionId, streamId, transportIndex, channelEndpoint, periodic, controlAddress);
        cmd.timeOfStatusMessageNs(this.nanoClock.nanoTime());
        this.pendingSetupMessages.add(cmd);
    }

    public void onAddSubscription(ReceiveChannelEndpoint channelEndpoint, int streamId) {
        channelEndpoint.addSubscription(streamId);
    }

    public void onAddSubscription(ReceiveChannelEndpoint channelEndpoint, int streamId, int sessionId) {
        channelEndpoint.addSubscription(streamId, sessionId);
    }

    public void onRemoveSubscription(ReceiveChannelEndpoint channelEndpoint, int streamId) {
        channelEndpoint.removeSubscription(streamId);
    }

    public void onRemoveSubscription(ReceiveChannelEndpoint channelEndpoint, int streamId, int sessionId) {
        channelEndpoint.removeSubscription(streamId, sessionId);
    }

    public void onNewPublicationImage(ReceiveChannelEndpoint channelEndpoint, PublicationImage image) {
        this.publicationImages.add(image);
        channelEndpoint.addPublicationImage(image);
    }

    public void onRegisterReceiveChannelEndpoint(ReceiveChannelEndpoint channelEndpoint) {
        if (!channelEndpoint.hasDestinationControl()) {
            channelEndpoint.openChannel(this.conductorProxy);
            channelEndpoint.registerForRead(this.dataTransportPoller);
            channelEndpoint.indicateActive();
            if (channelEndpoint.hasExplicitControl()) {
                this.addPendingSetupMessage(0, 0, 0, channelEndpoint, true, channelEndpoint.explicitControlAddress());
                channelEndpoint.sendSetupElicitingStatusMessage(0, channelEndpoint.explicitControlAddress(), 0, 0);
            }
        }
    }

    public void onCloseReceiveChannelEndpoint(ReceiveChannelEndpoint channelEndpoint) {
        channelEndpoint.closeMultiRcvDestination();
        channelEndpoint.close();
    }

    public void onRemoveCoolDown(ReceiveChannelEndpoint channelEndpoint, int sessionId, int streamId) {
        channelEndpoint.removeCoolDown(sessionId, streamId);
    }

    public void onAddDestination(ReceiveChannelEndpoint channelEndpoint, ReceiveDestinationUdpTransport transport) {
        transport.openChannel();
        int transportIndex = channelEndpoint.addDestination(transport);
        SelectionKey key = this.dataTransportPoller.registerForRead(channelEndpoint, transport, transportIndex);
        transport.selectionKey(key);
        if (transport.hasExplicitControl()) {
            this.addPendingSetupMessage(0, 0, transportIndex, channelEndpoint, true, transport.explicitControlAddress());
            channelEndpoint.sendSetupElicitingStatusMessage(transportIndex, transport.explicitControlAddress(), 0, 0);
        }
        for (PublicationImage image : this.publicationImages) {
            if (channelEndpoint != image.channelEndpoint()) continue;
            image.addDestination(transportIndex, transport);
        }
    }

    public void onRemoveDestination(ReceiveChannelEndpoint channelEndpoint, UdpChannel udpChannel) {
        int transportIndex = channelEndpoint.destination(udpChannel);
        if (-1 != transportIndex) {
            ReceiveDestinationUdpTransport transport = channelEndpoint.destination(transportIndex);
            this.dataTransportPoller.cancelRead(channelEndpoint, transport);
            channelEndpoint.removeDestination(transportIndex);
            CloseHelper.close((AutoCloseable)transport);
            this.dataTransportPoller.selectNowWithoutProcessing();
            for (PublicationImage image : this.publicationImages) {
                if (channelEndpoint != image.channelEndpoint()) continue;
                image.removeDestination(transportIndex);
            }
        }
    }

    private void checkPendingSetupMessages(long nowNs) {
        int lastIndex;
        ArrayList<PendingSetupMessageFromSource> pendingSetupMessages = this.pendingSetupMessages;
        for (int i = lastIndex = pendingSetupMessages.size() - 1; i >= 0; --i) {
            PendingSetupMessageFromSource pending = pendingSetupMessages.get(i);
            if (pending.timeOfStatusMessageNs() + Configuration.PENDING_SETUPS_TIMEOUT_NS - nowNs >= 0L) continue;
            if (!pending.isPeriodic()) {
                ArrayListUtil.fastUnorderedRemove(pendingSetupMessages, (int)i, (int)lastIndex--);
                pending.removeFromDataPacketDispatcher();
                continue;
            }
            if (!pending.shouldElicitSetupMessage()) continue;
            pending.channelEndpoint().sendSetupElicitingStatusMessage(pending.transportIndex(), pending.controlAddress(), pending.sessionId(), pending.streamId());
            pending.timeOfStatusMessageNs(nowNs);
        }
    }
}

