/*
 * Decompiled with CFR 0.152.
 */
package pureconfig;

import com.typesafe.config.impl.ConfigImplUtil;
import java.io.Serializable;
import java.time.Period;
import pureconfig.error.CannotConvert;
import pureconfig.error.FailureReason;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class PeriodUtils$ {
    public static PeriodUtils$ MODULE$;
    private final Function1<String, Either<FailureReason, Period>> fromString;

    static {
        new PeriodUtils$();
    }

    public Function1<String, Either<FailureReason, Period>> fromString() {
        return this.fromString;
    }

    public Either<FailureReason, Period> typesafeConfigParsePeriod(String input) {
        Left left;
        Tuple2<String, String> tuple2 = this.splitUnits(ConfigImplUtil.unicodeTrim((String)input));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String rawValueStr = (String)tuple2._1();
        String rawUnitStr = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)rawValueStr, (Object)rawUnitStr);
        Tuple2 tuple23 = tuple22;
        String rawValueStr2 = (String)tuple23._1();
        String rawUnitStr2 = (String)tuple23._2();
        String valueStr = ConfigImplUtil.unicodeTrim((String)rawValueStr2);
        String unitStr = this.pluralize(rawUnitStr2);
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(valueStr)).toInt());
        if (try_ instanceof Success) {
            Object object;
            Success success = (Success)try_;
            int n = BoxesRunTime.unboxToInt((Object)success.value());
            String string = unitStr;
            boolean bl = "".equals(string) ? true : ("d".equals(string) ? true : "days".equals(string));
            if (bl) {
                object = package$.MODULE$.Right().apply((Object)Period.ofDays(n));
            } else {
                boolean bl2 = "w".equals(string) ? true : "weeks".equals(string);
                if (bl2) {
                    object = package$.MODULE$.Right().apply((Object)Period.ofWeeks(n));
                } else {
                    boolean bl3 = "m".equals(string) ? true : ("mo".equals(string) ? true : "months".equals(string));
                    if (bl3) {
                        object = package$.MODULE$.Right().apply((Object)Period.ofMonths(n));
                    } else {
                        boolean bl4 = "y".equals(string) ? true : "years".equals(string);
                        object = bl4 ? package$.MODULE$.Right().apply((Object)Period.ofYears(n)) : package$.MODULE$.Left().apply((Object)new CannotConvert(input, "Period", new StringBuilder(46).append("Could not parse time unit '").append(unitStr).append("' (try d, w, mo, y)").toString()));
                    }
                }
            }
            left = object;
        } else {
            left = package$.MODULE$.Left().apply((Object)new CannotConvert(input, "Period", new StringBuilder(34).append("Could not parse duration number '").append(valueStr).append("'").toString()));
        }
        return left;
    }

    private Tuple2<String, String> splitUnits(String s) {
        return new StringOps(Predef$.MODULE$.augmentString(s)).splitAt(new StringOps(Predef$.MODULE$.augmentString(s)).lastIndexWhere((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)PeriodUtils$.$anonfun$splitUnits$1(BoxesRunTime.unboxToChar((Object)x$2)))) + 1);
    }

    private String pluralize(String s) {
        return s.length() > 2 && !s.endsWith("s") ? new StringBuilder(1).append(s).append("s").toString() : s;
    }

    public static final /* synthetic */ boolean $anonfun$splitUnits$1(char x$2) {
        return !RichChar$.MODULE$.isLetter$extension(Predef$.MODULE$.charWrapper(x$2));
    }

    private PeriodUtils$() {
        MODULE$ = this;
        this.fromString = (Function1 & Serializable & scala.Serializable)str -> (Either)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Right().apply((Object)Period.parse(str))).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.typesafeConfigParsePeriod((String)str));
    }
}

