/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.database.anonymizer.utils;

import com.typesafe.config.Config;
import com.xebialabs.database.anonymizer.DatabaseName;
import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.XldServerPaths;
import com.xebialabs.deployit.core.config.XldConfig;
import com.xebialabs.deployit.security.SecretKeyHolder;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import javax.crypto.SecretKey;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.ForwardOnlyResultSetTableFactory;
import org.dbunit.dataset.datatype.DefaultDataTypeFactory;
import org.dbunit.ext.db2.Db2DataTypeFactory;
import org.dbunit.ext.mssql.InsertIdentityOperation;
import org.dbunit.ext.mssql.MsSqlDataTypeFactory;
import org.dbunit.ext.mysql.MySqlDataTypeFactory;
import org.dbunit.ext.oracle.OracleDataTypeFactory;
import org.dbunit.ext.postgresql.PostgresqlDataTypeFactory;
import org.dbunit.operation.DatabaseOperation;

public class DbUtil {
    public static final String KEY_REPORTING_JDBC_URL = "xl.reporting.database.db-url";
    public static final String KEY_REPORTING_JDBC_DRIVER_CLASSNAME = "xl.reporting.database.db-driver-classname";
    public static final String KEY_REPORTING_JDBC_USERNAME = "xl.reporting.database.db-username";
    public static final String KEY_REPORTING_JDBC_PASSWORD = "xl.reporting.database.db-password";

    private static Connection getDriverConnection(boolean isReportingDb) throws SQLException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        DbUtil.initEncryption();
        Config xldConfig = new XldConfig("xl-deploy.conf", SecretKeyHolder.get()).rootConfig();
        Properties dbCredentials = DbUtil.getDbCredentials(xldConfig, isReportingDb);
        Driver driver = (Driver)Class.forName(xldConfig.getString(isReportingDb ? KEY_REPORTING_JDBC_DRIVER_CLASSNAME : "xl.repository.database.db-driver-classname")).newInstance();
        Connection driverConnection = driver.connect(xldConfig.getString(isReportingDb ? KEY_REPORTING_JDBC_URL : "xl.repository.database.db-url"), dbCredentials);
        driverConnection.setAutoCommit(true);
        return driverConnection;
    }

    private static Properties getDbCredentials(Config xldConfig, boolean isReportingDb) {
        Properties properties = new Properties();
        properties.put("user", xldConfig.getString(isReportingDb ? KEY_REPORTING_JDBC_USERNAME : "xl.repository.database.db-username"));
        properties.put("password", xldConfig.getString(isReportingDb ? KEY_REPORTING_JDBC_PASSWORD : "xl.repository.database.db-password"));
        return properties;
    }

    private static void initEncryption() {
        ServerConfigFile serverConfigFile = new ServerConfigFile(XldServerPaths.DEFAULT_CONFIGURATION_FILE);
        ServerConfiguration serverConfiguration = serverConfigFile.loadConfig(false, false);
        String repositoryKeyStorePassword = serverConfiguration.getRepositoryKeyStorePassword();
        SecretKey passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey((String)repositoryKeyStorePassword);
        PasswordEncrypter.init((SecretKey)passwordEncryptionKey);
    }

    public static String getDatabaseName(Connection connection) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        return metaData.getDatabaseProductName().toLowerCase();
    }

    private static void updateDatabaseConfig(DatabaseConnection connection, String databaseName) {
        DatabaseConfig config = connection.getConfig();
        config.setProperty("http://www.dbunit.org/features/caseSensitiveTableNames", (Object)true);
        config.setProperty("http://www.dbunit.org/features/qualifiedTableNames", (Object)true);
        config.setProperty("http://www.dbunit.org/features/allowEmptyFields", (Object)true);
        config.setProperty("http://www.dbunit.org/properties/resultSetTableFactory", (Object)new ForwardOnlyResultSetTableFactory());
        if (databaseName.contains(DatabaseName.Oracle.getName())) {
            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new OracleDataTypeFactory());
            config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)"\"?\"");
        } else if (databaseName.contains(DatabaseName.MSSQL.getName())) {
            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new MsSqlDataTypeFactory());
            config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)"\"?\"");
        } else if (databaseName.contains(DatabaseName.POSTGRES.getName())) {
            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new PostgresqlDataTypeFactory());
            config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)"\"?\"");
        } else if (databaseName.contains(DatabaseName.MYSQL.getName())) {
            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new MySqlDataTypeFactory());
            config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)"`?`");
        } else if (databaseName.contains(DatabaseName.DB2.getName())) {
            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new Db2DataTypeFactory());
            config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)"\"?\"");
        } else {
            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new DefaultDataTypeFactory());
            config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)"\"?\"");
        }
    }

    public static DatabaseConnection getDatabaseConnection(boolean isReportingDb) throws DatabaseUnitException, SQLException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        Connection driverConnection = DbUtil.getDriverConnection(isReportingDb);
        String databaseName = DbUtil.getDatabaseName(driverConnection);
        DatabaseConnection connection = databaseName.contains(DatabaseName.Oracle.getName()) ? new DatabaseConnection(driverConnection, driverConnection.getMetaData().getUserName()) : (databaseName.contains(DatabaseName.MSSQL.getName()) ? new DatabaseConnection(driverConnection, "dbo") : new DatabaseConnection(driverConnection));
        DbUtil.updateDatabaseConfig(connection, databaseName);
        return connection;
    }

    public static DatabaseOperation getDatabaseOperation(String databaseName, boolean dbRefresh) {
        if (databaseName.contains(DatabaseName.MSSQL.getName())) {
            return dbRefresh ? InsertIdentityOperation.REFRESH : InsertIdentityOperation.INSERT;
        }
        return dbRefresh ? DatabaseOperation.REFRESH : DatabaseOperation.INSERT;
    }

    public static void enableBatchProcessing(DatabaseConnection connection, int batchSize) {
        connection.getConfig().setProperty("http://www.dbunit.org/properties/batchSize", (Object)batchSize);
        connection.getConfig().setProperty("http://www.dbunit.org/features/batchedStatements", (Object)true);
    }
}

