/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.version.exporter;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.checksum.ChecksumAlgorithmProvider;
import com.xebialabs.deployit.packager.DarPackager;
import com.xebialabs.deployit.packager.ManifestWriter;
import com.xebialabs.deployit.packager.writers.ManifestXmlWriter;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.overthere.local.LocalFile;
import java.io.File;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExporterService {
    private final RepositoryService repositoryService;
    private final ChecksumAlgorithmProvider checksumAlgorithmProvider;

    @Autowired
    public ExporterService(RepositoryService repositoryService, ChecksumAlgorithmProvider checksumAlgorithmProvider) {
        this.repositoryService = repositoryService;
        this.checksumAlgorithmProvider = checksumAlgorithmProvider;
    }

    public LocalFile exportDar(String versionId, WorkDir workDir) {
        Preconditions.checkNotNull((Object)versionId, (Object)"id of the version to be exported is null");
        ConfigurationItem ci = this.repositoryService.read(versionId, workDir);
        Preconditions.checkArgument((boolean)ci.getType().instanceOf(Type.valueOf(Version.class)), (String)"Expected a subtype of udm.Version for exporting but got %s", (Object)ci.getType());
        File targetDir = new File(workDir.getPath());
        DarPackager darPackager = new DarPackager((ManifestWriter)new ManifestXmlWriter(), () -> ((ChecksumAlgorithmProvider)this.checksumAlgorithmProvider).getMessageDigest());
        return (LocalFile)LocalFile.valueOf((File)darPackager.buildPackage((Version)ci, targetDir.getAbsolutePath()).getFile());
    }
}

